/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteElementFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myText;

    public DeleteElementFix(@NotNull PsiElement element) {
        super(element);
        this.myText = null;
    }

    public DeleteElementFix(@NotNull PsiElement element, @NotNull @Nls String text) {
        super(element);
        this.myText = text;
    }

    @Nls
    @NotNull
    public String getText() {
        return (String)ObjectUtils.notNull((Object)this.myText, (Object)this.getFamilyName());
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("delete.element.fix.text", new Object[0]);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)file2)) {
            WriteAction.run(() -> new CommentTracker().deleteAndRestoreComments(startElement));
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

