/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.actions.TypeCookAction;
import org.jetbrains.annotations.NotNull;

public class GenerifyFileFix
implements IntentionAction,
LocalQuickFix {
    private String myFileName;

    @NotNull
    public String getText() {
        return QuickFixBundle.message("generify.text", this.myFileName);
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("generify.family", new Object[0]);
    }

    public void applyFix(final @NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        final PsiFile file2 = element.getContainingFile();
        if (this.isAvailable(project2, null, file2)) {
            this.myFileName = file2.getName();
            new WriteCommandAction(project2, new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Throwable {
                    GenerifyFileFix.this.invoke(project2, FileEditorManager.getInstance((Project)project2).getSelectedTextEditor(), file2);
                }
            }.execute();
        }
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (file2 != null && file2.isValid()) {
            this.myFileName = file2.getName();
            return PsiManager.getInstance((Project)project2).isInProject((PsiElement)file2);
        }
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        new TypeCookAction().getHandler().invoke(project2, editor, file2, null);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

