/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GoToSymbolFix
implements IntentionAction {
    private final SmartPsiElementPointer<NavigatablePsiElement> myPointer;
    private final String myMessage;

    public GoToSymbolFix(@NotNull NavigatablePsiElement symbol, @NotNull @Nls String message2) {
        this.myPointer = SmartPointerManager.getInstance((Project)symbol.getProject()).createSmartPsiElementPointer((PsiElement)symbol);
        this.myMessage = message2;
    }

    @Nls
    @NotNull
    public String getText() {
        return this.myMessage;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myPointer.getElement() != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        NavigatablePsiElement e = (NavigatablePsiElement)this.myPointer.getElement();
        if (e != null && e.isValid()) {
            e.navigate(true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

