/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class GuessTypeParameters {
    private final JVMElementFactory myFactory;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.GuessTypeParameters");
    private static final int SUBSTITUTED_NONE = 0;
    private static final int SUBSTITUTED_IN_REF = 1;
    private static final int SUBSTITUTED_IN_PARAMETERS = 2;

    public GuessTypeParameters(JVMElementFactory factory) {
        this.myFactory = factory;
    }

    private List<PsiType> matchingTypeParameters(PsiType[] paramVals, PsiTypeParameter[] params, ExpectedTypeInfo info) {
        PsiType type2 = info.getType();
        int kind2 = info.getKind();
        ArrayList<PsiType> result2 = new ArrayList<PsiType>();
        block5: for (int i2 = 0; i2 < paramVals.length; ++i2) {
            PsiType val = paramVals[i2];
            if (val == null) continue;
            switch (kind2) {
                case 0: {
                    if (!val.equals(type2)) continue block5;
                    result2.add((PsiType)this.myFactory.createType((PsiClass)params[i2]));
                    continue block5;
                }
                case 1: {
                    if (!type2.isAssignableFrom(val)) continue block5;
                    result2.add((PsiType)this.myFactory.createType((PsiClass)params[i2]));
                    continue block5;
                }
                case 2: {
                    if (!val.isAssignableFrom(type2)) continue block5;
                    result2.add((PsiType)this.myFactory.createType((PsiClass)params[i2]));
                }
            }
        }
        return result2;
    }

    public void setupTypeElement(PsiTypeElement typeElement, ExpectedTypeInfo[] infos, PsiSubstitutor substitutor, TemplateBuilder builder, @Nullable PsiElement context, PsiClass targetClass) {
        PsiType[] psiTypeArray;
        LOG.assertTrue(typeElement.isValid());
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiManager manager = typeElement.getManager();
        GlobalSearchScope scope = typeElement.getResolveScope();
        Project project2 = manager.getProject();
        if (infos.length == 1 && substitutor != null && substitutor != PsiSubstitutor.EMPTY) {
            PsiTypeParameter[] params;
            ExpectedTypeInfo info = infos[0];
            Map map2 = substitutor.getSubstitutionMap();
            PsiType[] vals = map2.values().toArray(PsiType.createArray((int)map2.size()));
            List<PsiType> types = this.matchingTypeParameters(vals, params = map2.keySet().toArray(new PsiTypeParameter[map2.size()]), info);
            if (!types.isEmpty()) {
                ContainerUtil.addAll(types, (Object[])ExpectedTypesProvider.processExpectedTypes(infos, new MyTypeVisitor(manager, scope), project2));
                builder.replaceElement((PsiElement)typeElement, (Expression)new TypeExpression(project2, types.toArray(PsiType.createArray((int)types.size()))));
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiType type2 = info.getType();
            PsiType defaultType = info.getDefaultType();
            try {
                PsiTypeElement inplaceTypeElement = ((PsiVariable)factory.createVariableDeclarationStatement("foo", type2, null).getDeclaredElements()[0]).getTypeElement();
                PsiSubstitutor rawingSubstitutor = GuessTypeParameters.getRawingSubstitutor(context, targetClass);
                int substitionResult = this.substituteToTypeParameters(typeElement, inplaceTypeElement, vals, params, builder, rawingSubstitutor, true);
                if (substitionResult != 0) {
                    if (substitionResult == 2) {
                        PsiJavaCodeReferenceElement refElement = typeElement.getInnermostComponentReferenceElement();
                        LOG.assertTrue(refElement != null && refElement.getReferenceNameElement() != null);
                        type2 = GuessTypeParameters.getComponentType(type2);
                        LOG.assertTrue(type2 != null);
                        defaultType = GuessTypeParameters.getComponentType(defaultType);
                        LOG.assertTrue(defaultType != null);
                        ExpectedTypeInfo info1 = ExpectedTypesProvider.createInfo((PsiType)((PsiClassType)defaultType).rawType(), 0, (PsiType)((PsiClassType)defaultType).rawType(), info.getTailType());
                        MyTypeVisitor visitor = new MyTypeVisitor(manager, scope);
                        builder.replaceElement(refElement.getReferenceNameElement(), (Expression)new TypeExpression(project2, ExpectedTypesProvider.processExpectedTypes(new ExpectedTypeInfo[]{info1}, visitor, project2)));
                    }
                    return;
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (infos.length == 0) {
            PsiType[] psiTypeArray2 = new PsiType[1];
            psiTypeArray = psiTypeArray2;
            psiTypeArray2[0] = typeElement.getType();
        } else {
            psiTypeArray = ExpectedTypesProvider.processExpectedTypes(infos, new MyTypeVisitor(manager, scope), project2);
        }
        PsiType[] types = psiTypeArray;
        builder.replaceElement((PsiElement)typeElement, (Expression)new TypeExpression(project2, types));
    }

    private static PsiSubstitutor getRawingSubstitutor(PsiElement context, PsiClass targetClass) {
        if (context == null || targetClass == null) {
            return PsiSubstitutor.EMPTY;
        }
        PsiManager manager = context.getManager();
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        for (PsiTypeParameterListOwner currContext = (PsiTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)context, PsiTypeParameterListOwner.class); currContext != null && !manager.areElementsEquivalent((PsiElement)currContext, (PsiElement)targetClass); currContext = currContext.getContainingClass()) {
            PsiTypeParameter[] typeParameters = currContext.getTypeParameters();
            substitutor = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory().createRawSubstitutor(substitutor, typeParameters);
        }
        return substitutor;
    }

    @Nullable
    private static PsiClassType getComponentType(PsiType type2) {
        if ((type2 = type2.getDeepComponentType()) instanceof PsiClassType) {
            return (PsiClassType)type2;
        }
        return null;
    }

    private int substituteToTypeParameters(PsiTypeElement typeElement, PsiTypeElement inplaceTypeElement, PsiType[] paramVals, PsiTypeParameter[] params, TemplateBuilder builder, PsiSubstitutor rawingSubstitutor, boolean toplevel) {
        PsiType type2 = inplaceTypeElement.getType();
        ArrayList<Object> types = new ArrayList<Object>();
        for (int i2 = 0; i2 < paramVals.length; ++i2) {
            PsiType val = paramVals[i2];
            if (val == null) {
                return 0;
            }
            if (!type2.equals(val)) continue;
            types.add(this.myFactory.createType((PsiClass)params[i2]));
        }
        if (!types.isEmpty()) {
            Project project2 = typeElement.getProject();
            PsiType substituted = rawingSubstitutor.substitute(type2);
            if (!"java.lang.Object".equals(substituted.getCanonicalText()) && (toplevel || substituted.equals(type2))) {
                types.add(substituted);
            }
            builder.replaceElement((PsiElement)typeElement, (Expression)new TypeExpression(project2, types.toArray(PsiType.createArray((int)types.size()))));
            return toplevel ? 1 : 2;
        }
        boolean substituted = false;
        PsiJavaCodeReferenceElement ref = typeElement.getInnermostComponentReferenceElement();
        PsiJavaCodeReferenceElement inplaceRef = inplaceTypeElement.getInnermostComponentReferenceElement();
        if (ref != null) {
            LOG.assertTrue(inplaceRef != null);
            PsiTypeElement[] innerTypeElements = ref.getParameterList().getTypeParameterElements();
            PsiTypeElement[] inplaceInnerTypeElements = inplaceRef.getParameterList().getTypeParameterElements();
            for (int i3 = 0; i3 < innerTypeElements.length; ++i3) {
                substituted |= this.substituteToTypeParameters(innerTypeElements[i3], inplaceInnerTypeElements[i3], paramVals, params, builder, rawingSubstitutor, false) != 0;
            }
        }
        return substituted ? 2 : 0;
    }

    public static class MyTypeVisitor
    extends PsiTypeVisitor<PsiType> {
        private final GlobalSearchScope myResolveScope;
        private final PsiManager myManager;

        public MyTypeVisitor(PsiManager manager, GlobalSearchScope resolveScope) {
            this.myManager = manager;
            this.myResolveScope = resolveScope;
        }

        public PsiType visitType(PsiType type2) {
            if (type2.equals(PsiType.NULL)) {
                return PsiType.getJavaLangObject((PsiManager)this.myManager, (GlobalSearchScope)this.myResolveScope);
            }
            return type2;
        }

        public PsiType visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return (PsiType)capturedWildcardType.getUpperBound().accept((PsiTypeVisitor)this);
        }
    }
}

