/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.ImportFilter;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyRule;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportClassFixBase<T extends PsiElement, R extends PsiReference>
implements HintAction,
HighPriorityAction {
    @NotNull
    private final T myElement;
    @NotNull
    private final R myRef;

    protected ImportClassFixBase(@NotNull T elem, @NotNull R ref) {
        this.myElement = elem;
        this.myRef = ref;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiFile file2) {
        PsiExpression expression2;
        if (!this.myElement.isValid()) {
            return false;
        }
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != null) {
            return false;
        }
        if (parent instanceof PsiReferenceExpression && (expression2 = ((PsiReferenceExpression)parent).getQualifierExpression()) != null && expression2 != this.myElement) {
            return false;
        }
        return !this.getClassesToImport(true).isEmpty();
    }

    @Nullable
    protected abstract String getReferenceName(@NotNull R var1);

    protected abstract PsiElement getReferenceNameElement(@NotNull R var1);

    protected abstract boolean hasTypeParameters(@NotNull R var1);

    @NotNull
    public List<PsiClass> getClassesToImport() {
        return this.getClassesToImport(false);
    }

    @NotNull
    public List<PsiClass> getClassesToImport(boolean acceptWrongNumberOfTypeParams) {
        List<PsiClass> filtered;
        JavaResolveResult result2;
        PsiElement element;
        if (this.myRef instanceof PsiJavaReference && (element = (result2 = ((PsiJavaReference)this.myRef).advancedResolve(true)).getElement()) instanceof PsiClass && result2.isValidResult()) {
            return Collections.emptyList();
        }
        String name = this.getReferenceName(this.myRef);
        GlobalSearchScope scope = this.myElement.getResolveScope();
        if (name == null) {
            return Collections.emptyList();
        }
        if (!this.canReferenceClass(this.myRef)) {
            return Collections.emptyList();
        }
        boolean referenceHasTypeParameters = this.hasTypeParameters(this.myRef);
        Project project2 = this.myElement.getProject();
        PsiClass[] classes2 = PsiShortNamesCache.getInstance((Project)project2).getClassesByName(name, scope);
        if (classes2.length == 0) {
            return Collections.emptyList();
        }
        List<PsiClass> classList = new ArrayList<PsiClass>(classes2.length);
        boolean isAnnotationReference = this.myElement.getParent() instanceof PsiAnnotation;
        PsiFile file2 = this.myElement.getContainingFile();
        for (PsiClass aClass : classes2) {
            String qName;
            if (isAnnotationReference && !aClass.isAnnotationType() || JavaCompletionUtil.isInExcludedPackage((PsiMember)aClass, false) || !acceptWrongNumberOfTypeParams && referenceHasTypeParameters && !aClass.hasTypeParameters() || (qName = aClass.getQualifiedName()) == null || qName.indexOf(46) == -1 || !PsiNameHelper.getInstance((Project)project2).isQualifiedName(qName) || !qName.endsWith(name) || file2 != null && !ImportFilter.shouldImport((PsiFile)file2, (String)qName) || !this.isAccessible((PsiMember)aClass, this.myElement)) continue;
            classList.add(aClass);
        }
        if (acceptWrongNumberOfTypeParams && referenceHasTypeParameters) {
            ArrayList<PsiClass> candidates = new ArrayList<PsiClass>();
            Iterator<PsiClass> iterator = classList.iterator();
            while (iterator.hasNext()) {
                PsiClass aClass = iterator.next();
                if (aClass.hasTypeParameters()) continue;
                iterator.remove();
                candidates.add(aClass);
            }
            if (classList.isEmpty()) {
                classList.addAll(candidates);
            }
        }
        if (!(filtered = this.filterByContext(classList = this.filterByRequiredMemberName(classList), this.myElement)).isEmpty()) {
            classList = filtered;
        }
        this.filterAlreadyImportedButUnresolved(classList);
        this.filerByPackageName(classList, file2);
        return classList;
    }

    protected void filerByPackageName(List<PsiClass> classList, PsiFile file2) {
        String packageName = StringUtil.getPackageName((String)this.getQualifiedName(this.myElement));
        if (!packageName.isEmpty() && file2 instanceof PsiJavaFile && Arrays.binarySearch(((PsiJavaFile)file2).getImplicitlyImportedPackages(), packageName) < 0) {
            Iterator<PsiClass> iterator = classList.iterator();
            while (iterator.hasNext()) {
                String classQualifiedName = iterator.next().getQualifiedName();
                if (classQualifiedName == null || packageName.equals(StringUtil.getPackageName((String)classQualifiedName))) continue;
                iterator.remove();
            }
        }
    }

    protected boolean canReferenceClass(R ref) {
        return true;
    }

    private List<PsiClass> filterByRequiredMemberName(List<PsiClass> classList) {
        List filtered;
        String memberName = this.getRequiredMemberName(this.myElement);
        if (memberName != null && !(filtered = ContainerUtil.findAll(classList, psiClass -> {
            PsiField field = psiClass.findFieldByName(memberName, true);
            if (field != null && field.hasModifierProperty("static") && this.isAccessible((PsiMember)field, this.myElement)) {
                return true;
            }
            PsiClass inner = psiClass.findInnerClassByName(memberName, true);
            if (inner != null && this.isAccessible((PsiMember)inner, this.myElement)) {
                return true;
            }
            for (PsiMethod method2 : psiClass.findMethodsByName(memberName, true)) {
                if (!method2.hasModifierProperty("static") || !this.isAccessible((PsiMember)method2, this.myElement)) continue;
                return true;
            }
            return false;
        })).isEmpty()) {
            classList = filtered;
        }
        return classList;
    }

    private void filterAlreadyImportedButUnresolved(@NotNull List<PsiClass> list) {
        PsiFile containingFile;
        PsiElement element = this.myRef.getElement();
        PsiFile psiFile = containingFile = element == null ? null : element.getContainingFile();
        if (!(containingFile instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)containingFile;
        PsiImportList importList = javaFile.getImportList();
        PsiImportStatementBase[] importStatements = importList == null ? PsiImportStatementBase.EMPTY_ARRAY : importList.getAllImportStatements();
        THashSet importedNames = new THashSet(importStatements.length);
        for (PsiImportStatementBase statement2 : importStatements) {
            String name;
            PsiJavaCodeReferenceElement ref = statement2.getImportReference();
            String string = name = ref == null ? null : ref.getReferenceName();
            if (name == null || ref.resolve() != null) continue;
            importedNames.add(name);
        }
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            PsiClass aClass = list.get(i2);
            String className = aClass.getName();
            if (className == null || !importedNames.contains(className)) continue;
            list.remove(i2);
        }
    }

    @Nullable
    protected String getRequiredMemberName(T reference) {
        return null;
    }

    @NotNull
    protected List<PsiClass> filterByContext(@NotNull List<PsiClass> candidates, @NotNull T ref) {
        return candidates;
    }

    protected abstract boolean isAccessible(PsiMember var1, T var2);

    protected abstract String getQualifiedName(T var1);

    protected static List<PsiClass> filterAssignableFrom(PsiType type2, List<PsiClass> candidates) {
        PsiClass actualClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type2);
        if (actualClass != null) {
            return ContainerUtil.findAll(candidates, psiClass -> InheritanceUtil.isInheritorOrSelf((PsiClass)actualClass, (PsiClass)psiClass, (boolean)true));
        }
        return candidates;
    }

    protected static List<PsiClass> filterBySuperMethods(PsiParameter parameter, List<PsiClass> candidates) {
        PsiMethod method2;
        PsiElement granny;
        PsiElement parent = parameter.getParent();
        if (parent instanceof PsiParameterList && (granny = parent.getParent()) instanceof PsiMethod && (method2 = (PsiMethod)granny).getModifierList().findAnnotation("java.lang.Override") != null) {
            PsiClass aClass = method2.getContainingClass();
            HashSet probableTypes = new HashSet();
            InheritanceUtil.processSupers((PsiClass)aClass, (boolean)false, arg_0 -> ImportClassFixBase.lambda$filterBySuperMethods$2(method2, (Set)probableTypes, arg_0));
            List filtered = ContainerUtil.filter(candidates, arg_0 -> ImportClassFixBase.lambda$filterBySuperMethods$3((Set)probableTypes, arg_0));
            if (!filtered.isEmpty()) {
                return filtered;
            }
        }
        return candidates;
    }

    public Result doFix(@NotNull Editor editor, boolean allowPopup, boolean allowCaretNearRef) {
        boolean isInModlessContext;
        List<PsiClass> classesToImport = this.getClassesToImport();
        if (classesToImport.isEmpty()) {
            return Result.POPUP_NOT_SHOWN;
        }
        try {
            Pattern pattern;
            Matcher matcher;
            String name = this.getQualifiedName(this.myElement);
            if (name != null && (matcher = (pattern = Pattern.compile(DaemonCodeAnalyzerSettings.getInstance().NO_AUTO_IMPORT_PATTERN)).matcher(name)).matches()) {
                return Result.POPUP_NOT_SHOWN;
            }
        }
        catch (PatternSyntaxException name) {
            // empty catch block
        }
        PsiFile psiFile = this.myElement.getContainingFile();
        if (classesToImport.size() > 1) {
            ImportClassFixBase.reduceSuggestedClassesBasedOnDependencyRuleViolation(psiFile, classesToImport);
        }
        PsiClass[] classes2 = classesToImport.toArray(new PsiClass[classesToImport.size()]);
        Project project2 = this.myElement.getProject();
        CodeInsightUtil.sortIdenticalShortNamedMembers((PsiMember[])classes2, this.myRef);
        AddImportAction action = this.createAddImportAction(classes2, project2, editor);
        boolean canImportHere = true;
        boolean bl = Registry.is((String)"ide.perProjectModality") ? !LaterInvocator.isInModalContextForProject(editor.getProject()) : (isInModlessContext = !LaterInvocator.isInModalContext());
        if (classes2.length == 1 && (canImportHere = this.canImportHere(allowCaretNearRef, editor, psiFile, classes2[0].getName())) && ImportClassFixBase.isAddUnambiguousImportsOnTheFlyEnabled(psiFile) && (ApplicationManager.getApplication().isUnitTestMode() || DaemonListeners.canChangeFileSilently((PsiFileSystemItem)psiFile)) && isInModlessContext && !ImportClassFixBase.autoImportWillInsertUnexpectedCharacters(classes2[0])) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> action.execute());
            return Result.CLASS_AUTO_IMPORTED;
        }
        if (allowPopup && canImportHere) {
            String hintText = ShowAutoImportPass.getMessage(classes2.length > 1, classes2[0].getQualifiedName());
            if (!ApplicationManager.getApplication().isUnitTestMode() && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
                HintManager.getInstance().showQuestionHint(editor, hintText, this.getStartOffset(this.myElement, this.myRef), this.getEndOffset(this.myElement, this.myRef), (QuestionAction)action);
            }
            return Result.POPUP_SHOWN;
        }
        return Result.POPUP_NOT_SHOWN;
    }

    public static boolean isAddUnambiguousImportsOnTheFlyEnabled(@NotNull PsiFile psiFile) {
        return FileTypeUtils.isInServerPageFile((PsiElement)psiFile) ? CodeInsightSettings.getInstance().JSP_ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY : CodeInsightSettings.getInstance().ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
    }

    protected int getStartOffset(T element, R ref) {
        return element.getTextOffset();
    }

    protected int getEndOffset(T element, R ref) {
        return element.getTextRange().getEndOffset();
    }

    private static boolean autoImportWillInsertUnexpectedCharacters(PsiClass aClass) {
        PsiClass containingClass = aClass.getContainingClass();
        return containingClass != null;
    }

    private boolean canImportHere(boolean allowCaretNearRef, Editor editor, PsiFile psiFile, String exampleClassName) {
        return (allowCaretNearRef || !this.isCaretNearRef(editor, this.myRef)) && !this.hasUnresolvedImportWhichCanImport(psiFile, exampleClassName);
    }

    protected abstract boolean isQualified(R var1);

    public boolean showHint(@NotNull Editor editor) {
        if (this.isQualified(this.myRef)) {
            return false;
        }
        Result result2 = this.doFix(editor, true, false);
        return result2 == Result.POPUP_SHOWN || result2 == Result.CLASS_AUTO_IMPORTED;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("import.class.fix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("import.class.fix", new Object[0]);
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract boolean hasUnresolvedImportWhichCanImport(PsiFile var1, String var2);

    private static void reduceSuggestedClassesBasedOnDependencyRuleViolation(PsiFile file2, List<PsiClass> availableClasses) {
        Project project2 = file2.getProject();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)project2);
        for (int i2 = availableClasses.size() - 1; i2 >= 0; --i2) {
            DependencyRule[] violated;
            PsiClass psiClass = availableClasses.get(i2);
            PsiFile targetFile = psiClass.getContainingFile();
            if (targetFile == null || (violated = validationManager.getViolatorDependencyRules(file2, targetFile)).length == 0) continue;
            availableClasses.remove(i2);
            if (availableClasses.size() == 1) break;
        }
    }

    private boolean isCaretNearRef(@NotNull Editor editor, @NotNull R ref) {
        PsiElement nameElement = this.getReferenceNameElement(ref);
        if (nameElement == null) {
            return false;
        }
        TextRange range = nameElement.getTextRange();
        int offset = editor.getCaretModel().getOffset();
        return offset == range.getEndOffset();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            List<PsiClass> classesToImport = this.getClassesToImport(true);
            PsiClass[] classes2 = classesToImport.toArray(new PsiClass[classesToImport.size()]);
            if (classes2.length == 0) {
                return;
            }
            AddImportAction action = this.createAddImportAction(classes2, project2, editor);
            action.execute();
        });
    }

    protected void bindReference(PsiReference reference, PsiClass targetClass) {
        reference.bindToElement((PsiElement)targetClass);
    }

    protected AddImportAction createAddImportAction(PsiClass[] classes2, Project project2, Editor editor) {
        return new AddImportAction(project2, (PsiReference)this.myRef, editor, classes2){

            @Override
            protected void bindReference(PsiReference ref, PsiClass targetClass) {
                ImportClassFixBase.this.bindReference(ref, targetClass);
            }
        };
    }

    private static /* synthetic */ boolean lambda$filterBySuperMethods$3(Set probableTypes, PsiClass psiClass) {
        return probableTypes.contains(psiClass);
    }

    private static /* synthetic */ boolean lambda$filterBySuperMethods$2(PsiMethod method2, Set probableTypes, PsiClass psiClass) {
        for (PsiMethod psiMethod : psiClass.findMethodsByName(method2.getName(), false)) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                ContainerUtil.addIfNotNull((Collection)probableTypes, (Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)psiParameter.getType()));
            }
        }
        return true;
    }

    public static enum Result {
        POPUP_SHOWN,
        CLASS_AUTO_IMPORTED,
        POPUP_NOT_SHOWN;

    }
}

