/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import org.jetbrains.annotations.NotNull;

public class InsertSuperFix
implements IntentionAction,
HighPriorityAction {
    private final PsiMethod myConstructor;

    public InsertSuperFix(@NotNull PsiMethod constructor) {
        this.myConstructor = constructor;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("insert.super.constructor.call.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("insert.super.constructor.call.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myConstructor.isValid() && this.myConstructor.getBody() != null && this.myConstructor.getBody().getLBrace() != null && this.myConstructor.getManager().isInProject((PsiElement)this.myConstructor);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return this.myConstructor;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiStatement superCall = JavaPsiFacade.getInstance((Project)this.myConstructor.getProject()).getElementFactory().createStatementFromText("super();", null);
        PsiCodeBlock body2 = this.myConstructor.getBody();
        PsiJavaToken lBrace = body2.getLBrace();
        body2.addAfter((PsiElement)superCall, (PsiElement)lBrace);
        lBrace = (PsiJavaToken)new PsiMatcherImpl((PsiElement)body2).firstChild(PsiMatchers.hasClass(PsiExpressionStatement.class)).firstChild(PsiMatchers.hasClass(PsiMethodCallExpression.class)).firstChild(PsiMatchers.hasClass(PsiExpressionList.class)).firstChild(PsiMatchers.hasClass(PsiJavaToken.class)).dot(PsiMatchers.hasText("(")).getElement();
        editor.getCaretModel().moveToOffset(lBrace.getTextOffset() + 1);
        UndoUtil.markPsiFileForUndo((PsiFile)file2);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

