/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.quickFix.ExternalLibraryResolver;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.intellij.lang.annotations.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JetBrainsAnnotationsExternalLibraryResolver
extends ExternalLibraryResolver {
    private static final ExternalLibraryDescriptor JAVA5 = new JetBrainsAnnotationsLibraryDescriptor("annotations-java5"){

        @Override
        @NotNull
        public List<String> getLibraryClassesRoots() {
            File annotationsJar = new File(PathManager.getLibPath(), "annotations.jar");
            if (annotationsJar.exists()) {
                return Collections.singletonList(FileUtil.toSystemIndependentName((String)annotationsJar.getAbsolutePath()));
            }
            return JetBrainsAnnotationsExternalLibraryResolver.getPathsToAnnotationsDirectoriesInDevelopmentMode("annotations");
        }
    };
    private static final ExternalLibraryDescriptor JAVA8 = new JetBrainsAnnotationsLibraryDescriptor("annotations"){

        @Override
        @NotNull
        public List<String> getLibraryClassesRoots() {
            File annotationsJar = new File(PathManager.getHomePath(), "redist/annotations-java8.jar");
            if (annotationsJar.exists()) {
                return Collections.singletonList(FileUtil.toSystemIndependentName((String)annotationsJar.getAbsolutePath()));
            }
            return JetBrainsAnnotationsExternalLibraryResolver.getPathsToAnnotationsDirectoriesInDevelopmentMode("annotations-java8");
        }
    };

    @NotNull
    private static List<String> getPathsToAnnotationsDirectoriesInDevelopmentMode(String moduleName) {
        String annotationsRoot = PathManager.getJarPathForClass(Flow.class);
        if (annotationsRoot == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(annotationsRoot, FileUtil.toSystemIndependentName((String)new File(new File(annotationsRoot).getParentFile(), moduleName).getAbsolutePath()));
    }

    @Override
    @Nullable
    public ExternalLibraryResolver.ExternalClassResolveResult resolveClass(@NotNull String shortClassName, @NotNull ThreeState isAnnotation, @NotNull Module contextModule) {
        if (AnnotationUtil.isJetbrainsAnnotation((String)shortClassName)) {
            ExternalLibraryDescriptor libraryDescriptor = JetBrainsAnnotationsExternalLibraryResolver.getAnnotationsLibraryDescriptor(contextModule);
            return new ExternalLibraryResolver.ExternalClassResolveResult("org.jetbrains.annotations." + shortClassName, libraryDescriptor);
        }
        return null;
    }

    @NotNull
    public static ExternalLibraryDescriptor getAnnotationsLibraryDescriptor(@NotNull Module contextModule) {
        boolean java8 = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)contextModule).isAtLeast(LanguageLevel.JDK_1_8);
        return java8 ? JAVA8 : JAVA5;
    }

    private static abstract class JetBrainsAnnotationsLibraryDescriptor
    extends ExternalLibraryDescriptor {
        public JetBrainsAnnotationsLibraryDescriptor(String artifactId) {
            super("org.jetbrains", artifactId);
        }
    }
}

