/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParameter;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MakeVarargParameterLastFix
implements IntentionAction {
    private final PsiParameter myParameter;

    public MakeVarargParameterLastFix(@NotNull PsiParameter parameter) {
        this.myParameter = parameter;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("make.vararg.parameter.last.text", this.myParameter.getName());
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("make.vararg.parameter.last.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myParameter.isValid() && this.myParameter.getManager().isInProject((PsiElement)this.myParameter);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return this.myParameter;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.myParameter.getParent().add((PsiElement)this.myParameter);
        this.myParameter.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }
}

