/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

public abstract class MethodArgumentFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(MethodArgumentFix.class);
    protected final PsiExpressionList myArgList;
    protected final int myIndex;
    private final ArgumentFixerActionFactory myArgumentFixerActionFactory;
    protected final PsiType myToType;

    protected MethodArgumentFix(@NotNull PsiExpressionList list, int i2, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
        this.myArgList = list;
        this.myIndex = i2;
        this.myArgumentFixerActionFactory = fixerActionFactory;
        this.myToType = toType instanceof PsiEllipsisType ? ((PsiEllipsisType)toType).toArrayType() : toType;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myToType != null && this.myToType.isValid() && this.myArgList.getExpressions().length > this.myIndex && this.myArgList.getExpressions()[this.myIndex] != null && this.myArgList.getExpressions()[this.myIndex].isValid();
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiExpression expression2 = this.myArgList.getExpressions()[this.myIndex];
        LOG.assertTrue(expression2 != null && expression2.isValid());
        PsiExpression modified = this.myArgumentFixerActionFactory.getModifiedArgument(expression2, this.myToType);
        LOG.assertTrue(modified != null, (Object)this.myArgumentFixerActionFactory);
        expression2.replace((PsiElement)modified);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("fix.argument.family", new Object[0]);
    }
}

