/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;

public class OptimizeImportsFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.OptimizeImportsFix");

    @NotNull
    public String getText() {
        return QuickFixBundle.message("optimize.imports.fix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("optimize.imports.fix", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return file2.getManager().isInProject((PsiElement)file2) && file2 instanceof PsiJavaFile;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!(file2 instanceof PsiJavaFile)) {
            return;
        }
        JavaCodeStyleManager.getInstance((Project)project2).optimizeImports(file2);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

