/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class RemoveParameterListFix
implements IntentionAction {
    private final PsiMethod myMethod;

    public RemoveParameterListFix(@NotNull PsiMethod method2) {
        this.myMethod = method2;
    }

    @NotNull
    public String getText() {
        return "Remove parameter list";
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myMethod.isValid();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiMethod emptyMethod = JavaPsiFacade.getElementFactory((Project)project2).createMethodFromText("void foo(){}", (PsiElement)this.myMethod);
        this.myMethod.getParameterList().replace((PsiElement)emptyMethod.getParameterList());
    }

    public boolean startInWriteAction() {
        return true;
    }
}

