/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveUnusedParameterFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myName;

    public RemoveUnusedParameterFix(PsiParameter parameter) {
        super((PsiElement)parameter);
        this.myName = parameter.getName();
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("remove.unused.parameter.text", this.myName);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("remove.unused.parameter.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiParameter myParameter = (PsiParameter)startElement;
        return myParameter.isValid() && myParameter.getDeclarationScope() instanceof PsiMethod && myParameter.getManager().isInProject((PsiElement)myParameter);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiParameter myParameter = (PsiParameter)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(myParameter.getContainingFile())) {
            return;
        }
        RemoveUnusedParameterFix.removeReferences(myParameter);
    }

    private static void removeReferences(PsiParameter parameter) {
        PsiMethod method2 = (PsiMethod)parameter.getDeclarationScope();
        ChangeSignatureProcessor processor2 = new ChangeSignatureProcessor(parameter.getProject(), method2, false, null, method2.getName(), method2.getReturnType(), RemoveUnusedParameterFix.getNewParametersInfo(method2, parameter));
        processor2.run();
    }

    public static ParameterInfoImpl[] getNewParametersInfo(PsiMethod method2, PsiParameter parameterToRemove) {
        ArrayList<ParameterInfoImpl> result2 = new ArrayList<ParameterInfoImpl>();
        PsiParameter[] parameters2 = method2.getParameterList().getParameters();
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            PsiParameter parameter = parameters2[i2];
            if (Comparing.equal((Object)parameter, (Object)parameterToRemove)) continue;
            result2.add(new ParameterInfoImpl(i2, parameter.getName(), parameter.getType()));
        }
        return result2.toArray(new ParameterInfoImpl[result2.size()]);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

