/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SideEffectWarningDialog;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RemoveUnusedVariableFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableFix");
    private final PsiVariable myVariable;

    public RemoveUnusedVariableFix(PsiVariable variable) {
        this.myVariable = variable;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message(this.myVariable instanceof PsiField ? "remove.unused.field" : "remove.unused.variable", this.myVariable.getName());
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("remove.unused.variable.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.myVariable != null && this.myVariable.isValid() && this.myVariable.getManager().isInProject((PsiElement)this.myVariable);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!FileModificationService.getInstance().prepareFileForWrite(this.myVariable.getContainingFile())) {
            return;
        }
        this.removeVariableAndReferencingStatements(editor);
    }

    private void removeVariableAndReferencingStatements(Editor editor) {
        ArrayList<PsiElement> references = new ArrayList<PsiElement>();
        ArrayList<PsiElement> sideEffects = new ArrayList<PsiElement>();
        boolean[] canCopeWithSideEffects = new boolean[]{true};
        try {
            PsiClass context;
            Object object = context = this.myVariable instanceof PsiField ? ((PsiField)this.myVariable).getContainingClass() : PsiUtil.getVariableCodeBlock((PsiVariable)this.myVariable, null);
            if (context != null) {
                RemoveUnusedVariableUtil.collectReferences((PsiElement)context, this.myVariable, references);
            }
            references.add((PsiElement)this.myVariable);
            for (PsiElement element : references) {
                Boolean result2 = RemoveUnusedVariableUtil.processUsage(element, this.myVariable, sideEffects, RemoveUnusedVariableUtil.RemoveMode.CANCEL);
                if (result2 == null) {
                    return;
                }
                canCopeWithSideEffects[0] = canCopeWithSideEffects[0] & result2;
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        RemoveUnusedVariableUtil.RemoveMode deleteMode = RemoveUnusedVariableFix.showSideEffectsWarning(sideEffects, this.myVariable, editor, canCopeWithSideEffects[0]);
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                RemoveUnusedVariableUtil.deleteReferences(this.myVariable, references, deleteMode);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    public static RemoveUnusedVariableUtil.RemoveMode showSideEffectsWarning(List<PsiElement> sideEffects, PsiVariable variable, Editor editor, boolean canCopeWithSideEffects, @NonNls String beforeText, @NonNls String afterText) {
        if (sideEffects.isEmpty()) {
            return RemoveUnusedVariableUtil.RemoveMode.DELETE_ALL;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return canCopeWithSideEffects ? RemoveUnusedVariableUtil.RemoveMode.MAKE_STATEMENT : RemoveUnusedVariableUtil.RemoveMode.DELETE_ALL;
        }
        Project project2 = editor.getProject();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project2);
        PsiElement[] elements = PsiUtilCore.toPsiElementArray(sideEffects);
        EditorColorsManager manager = EditorColorsManager.getInstance();
        TextAttributes attributes = manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        highlightManager.addOccurrenceHighlights(editor, elements, attributes, true, null);
        SideEffectWarningDialog dialog2 = new SideEffectWarningDialog(project2, false, variable, beforeText, afterText, canCopeWithSideEffects);
        dialog2.show();
        int code2 = dialog2.getExitCode();
        return RemoveUnusedVariableUtil.RemoveMode.values()[code2];
    }

    private static RemoveUnusedVariableUtil.RemoveMode showSideEffectsWarning(List<PsiElement> sideEffects, PsiVariable variable, Editor editor, boolean canCopeWithSideEffects) {
        PsiElement sideEffect;
        String text = sideEffects.isEmpty() ? "" : ((sideEffect = sideEffects.get(0)) instanceof PsiExpression ? PsiExpressionTrimRenderer.render((PsiExpression)((PsiExpression)sideEffect)) : sideEffect.getText());
        return RemoveUnusedVariableFix.showSideEffectsWarning(sideEffects, variable, editor, canCopeWithSideEffects, text, text);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

