/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameElementFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(RenameElementFix.class);
    private final String myNewName;
    private final String myText;

    public RenameElementFix(@NotNull PsiNamedElement element) {
        super((PsiElement)element);
        VirtualFile vFile = element.getContainingFile().getVirtualFile();
        assert (vFile != null) : element;
        this.myNewName = vFile.getNameWithoutExtension();
        this.myText = CodeInsightBundle.message((String)"rename.public.class.text", (Object[])new Object[]{element.getName(), this.myNewName});
    }

    public RenameElementFix(@NotNull PsiNamedElement element, @NotNull String newName) {
        super((PsiElement)element);
        this.myNewName = newName;
        this.myText = CodeInsightBundle.message((String)"rename.named.element.text", (Object[])new Object[]{element.getName(), this.myNewName});
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"rename.element.family", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (this.isAvailable(project2, null, file2)) {
            LOG.assertTrue(file2 == startElement.getContainingFile());
            if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                return;
            }
            RenameProcessor processor2 = new RenameProcessor(project2, startElement, this.myNewName, false, false);
            processor2.run();
        }
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return startElement.isValid() && RenameUtil.isValidName(project2, startElement, this.myNewName);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

