/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.ReferenceNameExpression;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RenameWrongRefFix
implements IntentionAction {
    private final PsiReferenceExpression myRefExpr;
    @NonNls
    private static final String INPUT_VARIABLE_NAME = "INPUTVAR";
    @NonNls
    private static final String OTHER_VARIABLE_NAME = "OTHERVAR";
    private final boolean myUnresolvedOnly;

    public RenameWrongRefFix(@NotNull PsiReferenceExpression refExpr) {
        this(refExpr, false);
    }

    public RenameWrongRefFix(@NotNull PsiReferenceExpression refExpr, boolean unresolvedOnly) {
        this.myRefExpr = refExpr;
        this.myUnresolvedOnly = unresolvedOnly;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("rename.wrong.reference.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("rename.wrong.reference.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!this.myRefExpr.isValid() || !this.myRefExpr.getManager().isInProject((PsiElement)this.myRefExpr)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement refName = this.myRefExpr.getReferenceNameElement();
        if (refName == null) {
            return false;
        }
        TextRange textRange = refName.getTextRange();
        if (textRange == null || offset < textRange.getStartOffset() || offset > textRange.getEndOffset()) {
            return false;
        }
        return !CreateFromUsageUtils.isValidReference((PsiReference)this.myRefExpr, this.myUnresolvedOnly);
    }

    private LookupElement[] collectItems() {
        boolean qualified;
        LinkedHashSet<LookupElementBuilder> items = new LinkedHashSet<LookupElementBuilder>();
        boolean bl = qualified = this.myRefExpr.getQualifierExpression() != null;
        if (!qualified && !(this.myRefExpr.getParent() instanceof PsiMethodCallExpression)) {
            PsiVariable[] vars;
            for (PsiVariable var : vars = CreateFromUsageUtils.guessMatchingVariables((PsiExpression)this.myRefExpr)) {
                items.add(LookupElementBuilder.create((String)var.getName()));
            }
        } else {
            PsiElement[] variants;
            items.add(LookupElementBuilder.create((String)this.myRefExpr.getReferenceName()));
            class MyScopeProcessor
            extends BaseScopeProcessor {
                ArrayList<PsiElement> myResult = new ArrayList();
                boolean myFilterMethods;
                boolean myFilterStatics;

                MyScopeProcessor(PsiReferenceExpression refExpression) {
                    this.myFilterMethods = refExpression.getParent() instanceof PsiMethodCallExpression;
                    PsiExpression qualifier = refExpression.getQualifierExpression();
                    if (qualifier instanceof PsiReferenceExpression) {
                        PsiElement e = ((PsiReferenceExpression)qualifier).resolve();
                        this.myFilterStatics = e instanceof PsiClass;
                    } else if (qualifier == null) {
                        PsiModifierListOwner scope = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiModifierListOwner.class);
                        this.myFilterStatics = scope != null && scope.hasModifierProperty("static");
                    }
                }

                public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                    if (element instanceof PsiNamedElement && element instanceof PsiModifierListOwner && this.myFilterMethods == element instanceof PsiMethod && ((PsiModifierListOwner)element).hasModifierProperty("static") == this.myFilterStatics) {
                        this.myResult.add(element);
                    }
                    return true;
                }

                public PsiElement[] getVariants() {
                    return PsiUtilCore.toPsiElementArray(this.myResult);
                }
            }
            MyScopeProcessor processor2 = new MyScopeProcessor(this.myRefExpr);
            this.myRefExpr.processVariants((PsiScopeProcessor)processor2);
            for (PsiElement variant : variants = processor2.getVariants()) {
                items.add(LookupElementBuilder.create((String)((PsiNamedElement)variant).getName()));
            }
        }
        return items.toArray(new LookupElement[items.size()]);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiReferenceExpression[] refs = CreateFromUsageUtils.collectExpressions((PsiExpression)this.myRefExpr, PsiMember.class, PsiFile.class);
        PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)this.myRefExpr, (Class[])new Class[]{PsiMember.class, PsiFile.class});
        LookupElement[] items = this.collectItems();
        ReferenceNameExpression refExpr = new ReferenceNameExpression(items, this.myRefExpr.getReferenceName());
        TemplateBuilderImpl builder = new TemplateBuilderImpl(element);
        for (PsiReferenceExpression expr : refs) {
            if (!expr.equals(this.myRefExpr)) {
                builder.replaceElement(expr.getReferenceNameElement(), OTHER_VARIABLE_NAME, INPUT_VARIABLE_NAME, false);
                continue;
            }
            builder.replaceElement(expr.getReferenceNameElement(), INPUT_VARIABLE_NAME, (Expression)refExpr, true);
        }
        float proportion = EditorUtil.calcVerticalScrollProportion(editor);
        editor.getCaretModel().moveToOffset(element.getTextRange().getStartOffset());
        Template template = builder.buildInlineTemplate();
        editor.getCaretModel().moveToOffset(element.getTextRange().getStartOffset());
        TemplateManager.getInstance(project2).startTemplate(editor, template);
        EditorUtil.setVerticalScrollProportion(editor, proportion);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

