/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeDeleteFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public SafeDeleteFix(@NotNull PsiElement element) {
        super(element);
    }

    @NotNull
    public String getText() {
        PsiElement startElement = this.getStartElement();
        return QuickFixBundle.message("safe.delete.text", startElement == null ? "" : HighlightMessageUtil.getSymbolName(startElement, PsiSubstitutor.EMPTY));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("safe.delete.family", new Object[0]);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiElement[] elements = new PsiElement[]{startElement};
        if (startElement instanceof PsiParameter) {
            SafeDeleteProcessor.createInstance(project2, null, elements, false, false, true).run();
        } else {
            SafeDeleteHandler.invoke(project2, elements, true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

