/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class SetupJDKFix
implements IntentionAction,
HighPriorityAction {
    private static final SetupJDKFix ourInstance = new SetupJDKFix();

    public static SetupJDKFix getInstance() {
        return ourInstance;
    }

    private SetupJDKFix() {
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("setup.jdk.location.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("setup.jdk.location.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return JavaPsiFacade.getInstance((Project)project2).findClass("java.lang.Object", file2.getResolveScope()) == null;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        Sdk projectJdk = ProjectSettingsService.getInstance(project2).chooseAndSetSdk();
        if (projectJdk == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
            if (module2 != null) {
                ModuleRootModificationUtil.setSdkInherited((Module)module2);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

