/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StaticImportMemberFix<T extends PsiMember>
implements IntentionAction,
HintAction {
    private List<T> candidates;

    @NotNull
    protected abstract String getBaseText();

    @NotNull
    protected abstract String getMemberPresentableText(T var1);

    @NotNull
    public String getText() {
        String text = this.getBaseText();
        text = this.candidates != null && this.candidates.size() == 1 ? text + " '" + this.getMemberPresentableText((PsiMember)this.candidates.get(0)) + "'" : text + "...";
        return text;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        List<T> list;
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2)) return false;
        if (!(file2 instanceof PsiJavaFile)) return false;
        if (this.getElement() == null) return false;
        if (!this.getElement().isValid()) return false;
        if (this.getQualifierExpression() != null) return false;
        if (this.resolveRef() != null) return false;
        if (!file2.getManager().isInProject((PsiElement)file2)) return false;
        if (this.candidates == null) {
            this.candidates = this.getMembersToImport(false);
            list = this.candidates;
        } else {
            list = this.candidates;
        }
        if (list.isEmpty()) return false;
        return true;
    }

    public final List<T> getMembersToImport() {
        return this.getMembersToImport(false);
    }

    @NotNull
    protected abstract List<T> getMembersToImport(boolean var1);

    public static boolean isExcluded(PsiMember method2) {
        String name = PsiUtil.getMemberQualifiedName((PsiMember)method2);
        return name != null && JavaProjectCodeInsightSettings.getSettings(method2.getProject()).isExcluded(name);
    }

    @NotNull
    protected abstract QuestionAction createQuestionAction(List<T> var1, @NotNull Project var2, Editor var3);

    @Nullable
    protected abstract PsiElement getElement();

    @Nullable
    protected abstract PsiElement getQualifierExpression();

    @Nullable
    protected abstract PsiElement resolveRef();

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            List<T> methodsToImport = this.getMembersToImport(false);
            if (methodsToImport.isEmpty()) {
                return;
            }
            this.createQuestionAction(methodsToImport, project2, editor).execute();
        });
    }

    private ImportClassFixBase.Result doFix(Editor editor) {
        if (!CodeInsightSettings.getInstance().ADD_MEMBER_IMPORTS_ON_THE_FLY) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        List<T> candidates = this.getMembersToImport(true);
        if (candidates.isEmpty()) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        PsiElement element = this.getElement();
        if (element == null) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        QuestionAction action = this.createQuestionAction(candidates, element.getProject(), editor);
        String hintText = ShowAutoImportPass.getMessage(candidates.size() > 1, this.getMemberPresentableText((PsiMember)candidates.get(0)));
        if (!ApplicationManager.getApplication().isUnitTestMode() && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            TextRange textRange = element.getTextRange();
            HintManager.getInstance().showQuestionHint(editor, hintText, textRange.getStartOffset(), textRange.getEndOffset(), action);
        }
        return ImportClassFixBase.Result.POPUP_SHOWN;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean showHint(@NotNull Editor editor) {
        PsiElement callExpression = this.getElement();
        if (callExpression == null || this.getQualifierExpression() != null) {
            return false;
        }
        ImportClassFixBase.Result result2 = this.doFix(editor);
        return result2 == ImportClassFixBase.Result.POPUP_SHOWN || result2 == ImportClassFixBase.Result.CLASS_AUTO_IMPORTED;
    }
}

