/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMemberFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticMembersProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticImportMethodFix
extends StaticImportMemberFix<PsiMethod> {
    private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCall;

    public StaticImportMethodFix(@NotNull PsiMethodCallExpression methodCallExpression) {
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        return QuickFixBundle.message("static.import.method.text", new Object[0]);
    }

    @Override
    @NotNull
    protected String getMemberPresentableText(PsiMethod method2) {
        return PsiFormatUtil.formatMethod((PsiMethod)method2, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)0);
    }

    @Override
    @NotNull
    protected List<PsiMethod> getMembersToImport(boolean applicableOnly) {
        String name;
        Project project2 = this.myMethodCall.getProject();
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)project2);
        PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
        PsiReferenceExpression reference = element == null ? null : element.getMethodExpression();
        String string = name = reference == null ? null : reference.getReferenceName();
        if (name == null) {
            return Collections.emptyList();
        }
        MyStaticMethodProcessor processor2 = new MyStaticMethodProcessor(element);
        cache2.processMethodsWithName(name, element.getResolveScope(), (Processor)processor2);
        return processor2.getMembersToImport(applicableOnly);
    }

    @NotNull
    protected StaticImportMethodQuestionAction<PsiMethod> createQuestionAction(List<PsiMethod> methodsToImport, @NotNull Project project2, Editor editor) {
        return new StaticImportMethodQuestionAction<PsiMethod>(project2, editor, methodsToImport, this.myMethodCall);
    }

    @Override
    @Nullable
    protected PsiElement getElement() {
        return this.myMethodCall.getElement();
    }

    @Override
    @Nullable
    protected PsiElement getQualifierExpression() {
        PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
        return element != null ? element.getMethodExpression().getQualifierExpression() : null;
    }

    @Override
    @Nullable
    protected PsiElement resolveRef() {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)this.getElement();
        return methodCallExpression != null ? methodCallExpression.resolveMethod() : null;
    }

    private static class MyStaticMethodProcessor
    extends StaticMembersProcessor<PsiMethod> {
        private MyStaticMethodProcessor(PsiMethodCallExpression place) {
            super((PsiElement)place);
        }

        @Override
        protected boolean isApplicable(PsiMethod method2, PsiElement place) {
            PsiExpressionList argumentList = ((PsiMethodCallExpression)place).getArgumentList();
            MethodCandidateInfo candidateInfo = new MethodCandidateInfo((PsiElement)method2, PsiSubstitutor.EMPTY, false, false, (PsiElement)argumentList, null, argumentList.getExpressionTypes(), null);
            PsiSubstitutor substitutorForMethod = candidateInfo.getSubstitutor();
            if (PsiUtil.isApplicable((PsiMethod)method2, (PsiSubstitutor)substitutorForMethod, (PsiExpressionList)argumentList)) {
                PsiType returnType = substitutorForMethod.substitute(method2.getReturnType());
                PsiType expectedType = this.getExpectedType();
                return expectedType == null || returnType == null || TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)returnType);
            }
            return false;
        }
    }
}

