/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import org.jetbrains.annotations.NotNull;

public class SuperMethodReturnFix
implements IntentionAction {
    private final PsiType mySuperMethodType;
    private final PsiMethod mySuperMethod;

    public SuperMethodReturnFix(@NotNull PsiMethod superMethod, @NotNull PsiType superMethodType) {
        this.mySuperMethodType = superMethodType;
        this.mySuperMethod = superMethod;
    }

    @NotNull
    public String getText() {
        String name = PsiFormatUtil.formatMethod((PsiMethod)this.mySuperMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0);
        return QuickFixBundle.message("fix.super.method.return.type.text", name, JavaHighlightUtil.formatType(this.mySuperMethodType));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("fix.super.method.return.type.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.mySuperMethod.isValid() && this.mySuperMethod.getManager().isInProject((PsiElement)this.mySuperMethod) && this.mySuperMethodType.isValid();
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!FileModificationService.getInstance().prepareFileForWrite(this.mySuperMethod.getContainingFile())) {
            return;
        }
        ChangeSignatureProcessor processor2 = new ChangeSignatureProcessor(project2, this.mySuperMethod, false, null, this.mySuperMethod.getName(), this.mySuperMethodType, ParameterInfoImpl.fromMethod(this.mySuperMethod));
        processor2.run();
    }

    public boolean startInWriteAction() {
        return false;
    }
}

