/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.ide.TypePresentationService;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariableArrayTypeFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final PsiArrayType myTargetType;
    private final String myName;
    private final String myFamilyName;

    private VariableArrayTypeFix(@NotNull PsiArrayInitializerExpression initializer, @NotNull PsiArrayType arrayType, @NotNull PsiVariable variable) {
        super((PsiElement)initializer);
        this.myTargetType = arrayType;
        PsiNewExpression myNewExpression = VariableArrayTypeFix.getNewExpressionLocal(initializer);
        this.myName = this.myTargetType.equals((Object)variable.getType()) && myNewExpression != null ? QuickFixBundle.message("change.new.operator.type.text", VariableArrayTypeFix.getNewText((PsiElement)myNewExpression, initializer), this.myTargetType.getCanonicalText(), "") : QuickFixBundle.message("fix.variable.type.text", VariableArrayTypeFix.formatType(variable), variable.getName(), this.myTargetType.getCanonicalText());
        this.myFamilyName = QuickFixBundle.message(this.myTargetType.equals((Object)variable.getType()) && myNewExpression != null ? "change.new.operator.type.family" : "fix.variable.type.family", new Object[0]);
    }

    @Nullable
    public static VariableArrayTypeFix createFix(PsiArrayInitializerExpression initializer, @NotNull PsiType componentType) {
        PsiArrayType arrayType = new PsiArrayType(componentType);
        PsiArrayInitializerExpression arrayInitializer = initializer;
        while (arrayInitializer.getParent() instanceof PsiArrayInitializerExpression) {
            arrayInitializer = (PsiArrayInitializerExpression)arrayInitializer.getParent();
            arrayType = new PsiArrayType((PsiType)arrayType);
        }
        PsiVariable variable = VariableArrayTypeFix.getVariableLocal(arrayInitializer);
        if (variable == null) {
            return null;
        }
        return new VariableArrayTypeFix(arrayInitializer, arrayType, variable);
    }

    private static String formatType(@NotNull PsiVariable variable) {
        FindUsagesProvider provider2 = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(variable.getLanguage());
        String type2 = provider2.getType((PsiElement)variable);
        if (StringUtil.isNotEmpty((String)type2)) {
            return type2;
        }
        return TypePresentationService.getService().getTypePresentableName(variable.getClass());
    }

    private static PsiArrayInitializerExpression getInitializer(PsiArrayInitializerExpression initializer) {
        PsiArrayInitializerExpression arrayInitializer = initializer;
        while (arrayInitializer.getParent() instanceof PsiArrayInitializerExpression) {
            arrayInitializer = (PsiArrayInitializerExpression)arrayInitializer.getParent();
        }
        return arrayInitializer;
    }

    private static PsiVariable getVariableLocal(@NotNull PsiArrayInitializerExpression initializer) {
        PsiVariable variableLocal = null;
        PsiElement parent = initializer.getParent();
        if (parent instanceof PsiVariable) {
            variableLocal = (PsiVariable)parent;
        } else if (parent instanceof PsiNewExpression) {
            PsiNewExpression newExpressionLocal = (PsiNewExpression)parent;
            PsiElement newParent = newExpressionLocal.getParent();
            if (newParent instanceof PsiAssignmentExpression) {
                variableLocal = VariableArrayTypeFix.getFromAssignment((PsiAssignmentExpression)newParent);
            } else if (newParent instanceof PsiVariable) {
                variableLocal = (PsiVariable)newParent;
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            variableLocal = VariableArrayTypeFix.getFromAssignment((PsiAssignmentExpression)parent);
        }
        return variableLocal;
    }

    private static PsiNewExpression getNewExpressionLocal(@NotNull PsiArrayInitializerExpression initializer) {
        PsiNewExpression newExpressionLocal = null;
        PsiElement parent = initializer.getParent();
        if (!(parent instanceof PsiVariable) && parent instanceof PsiNewExpression) {
            newExpressionLocal = (PsiNewExpression)parent;
        }
        return newExpressionLocal;
    }

    @Nullable
    private static PsiVariable getFromAssignment(PsiAssignmentExpression assignment) {
        PsiExpression reference = assignment.getLExpression();
        PsiElement referencedElement = reference instanceof PsiReferenceExpression ? ((PsiReferenceExpression)reference).resolve() : null;
        return referencedElement != null && referencedElement instanceof PsiVariable ? (PsiVariable)referencedElement : null;
    }

    private static String getNewText(PsiElement myNewExpression, PsiArrayInitializerExpression myInitializer) {
        String newText = myNewExpression.getText();
        int initializerIdx = newText.indexOf(myInitializer.getText());
        if (initializerIdx != -1) {
            return newText.substring(0, initializerIdx).trim();
        }
        return newText;
    }

    @NotNull
    public String getText() {
        return this.myName;
    }

    @NotNull
    public String getFamilyName() {
        return this.myFamilyName;
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiArrayInitializerExpression myInitializer = (PsiArrayInitializerExpression)startElement;
        PsiVariable myVariable = VariableArrayTypeFix.getVariableLocal(myInitializer);
        return myVariable != null && myVariable.isValid() && myVariable.getManager().isInProject((PsiElement)myVariable) && this.myTargetType.isValid() && myInitializer.isValid();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiArrayInitializerExpression myInitializer = (PsiArrayInitializerExpression)startElement;
        PsiVariable myVariable = VariableArrayTypeFix.getVariableLocal(myInitializer);
        if (myVariable == null) {
            return;
        }
        PsiNewExpression myNewExpression = VariableArrayTypeFix.getNewExpressionLocal(myInitializer);
        if (!FileModificationService.getInstance().prepareFileForWrite(myVariable.getContainingFile())) {
            return;
        }
        if (!this.myTargetType.equals((Object)myVariable.getType())) {
            WriteAction.run(() -> this.fixVariableType(project2, file2, myVariable));
        }
        if (myNewExpression != null) {
            if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                return;
            }
            WriteAction.run(() -> this.fixArrayInitializer(myInitializer, myNewExpression));
        }
    }

    private void fixVariableType(@NotNull Project project2, @NotNull PsiFile file2, PsiVariable myVariable) {
        myVariable.normalizeDeclaration();
        myVariable.getTypeElement().replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createTypeElement((PsiType)this.myTargetType));
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)myVariable);
        if (!myVariable.getContainingFile().equals(file2)) {
            UndoUtil.markPsiFileForUndo((PsiFile)myVariable.getContainingFile());
        }
    }

    private void fixArrayInitializer(PsiArrayInitializerExpression myInitializer, PsiNewExpression myNewExpression) {
        String text = "new " + this.myTargetType.getCanonicalText() + "{}";
        PsiNewExpression newExpression = (PsiNewExpression)JavaPsiFacade.getElementFactory((Project)myNewExpression.getProject()).createExpressionFromText(text, myNewExpression.getParent());
        PsiElement[] children2 = newExpression.getChildren();
        children2[children2.length - 1].replace((PsiElement)myInitializer);
        myNewExpression.replace((PsiElement)newExpression);
    }
}

