/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapArrayToArraysAsListFix
extends MethodArgumentFix {
    public static final ArgumentFixerActionFactory REGISTAR = new MyFixerActionFactory();

    protected WrapArrayToArraysAsListFix(@NotNull PsiExpressionList list, int i2, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
        super(list, i2, toType, fixerActionFactory);
    }

    @NotNull
    public String getText() {
        if (this.myArgList.getExpressions().length == 1) {
            return QuickFixBundle.message("wrap.array.to.arrays.as.list.single.parameter.text", new Object[0]);
        }
        return QuickFixBundle.message("wrap.array.to.arrays.as.list.parameter.text", this.myIndex + 1);
    }

    public static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
            PsiType exprType = expression2.getType();
            if (!(exprType instanceof PsiArrayType) || !(toType instanceof PsiClassType)) {
                return null;
            }
            PsiClass resolvedToType = ((PsiClassType)toType).resolve();
            if (resolvedToType == null) {
                return null;
            }
            PsiClass javaUtilList = MyFixerActionFactory.getJavaUtilList((PsiElement)expression2);
            if (javaUtilList == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)javaUtilList, (PsiClass)resolvedToType, (boolean)true)) {
                return null;
            }
            PsiType[] parameters2 = ((PsiClassType)toType).getParameters();
            PsiType arrayComponentType = ((PsiArrayType)exprType).getComponentType();
            if (parameters2.length != 1 || !parameters2[0].equals(arrayComponentType)) {
                return null;
            }
            String rawNewExpression = String.format("java.util.Arrays.asList(%s)", expression2.getText());
            Project project2 = expression2.getProject();
            PsiExpression newExpression = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createExpressionFromText(rawNewExpression, null);
            return (PsiExpression)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)newExpression);
        }

        @Nullable
        private static PsiClass getJavaUtilList(PsiElement context) {
            return JavaPsiFacade.getInstance((Project)context.getProject()).findClass("java.util.List", context.getResolveScope());
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            return true;
        }

        @Override
        public MethodArgumentFix createFix(PsiExpressionList list, int i2, PsiType toType) {
            return new WrapArrayToArraysAsListFix(list, i2, toType, this);
        }
    }
}

