/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapObjectWithOptionalOfNullableFix
extends MethodArgumentFix
implements HighPriorityAction {
    public static final ArgumentFixerActionFactory REGISTAR = new MyFixerActionFactory();

    protected WrapObjectWithOptionalOfNullableFix(@NotNull PsiExpressionList list, int i2, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
        super(list, i2, toType, fixerActionFactory);
    }

    @NotNull
    public String getText() {
        if (this.myArgList.getExpressions().length == 1) {
            return QuickFixBundle.message("wrap.with.optional.single.parameter.text", new Object[0]);
        }
        return QuickFixBundle.message("wrap.with.optional.parameter.text", this.myIndex + 1);
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return PsiUtil.isLanguageLevel8OrHigher((PsiElement)file2) && super.isAvailable(project2, editor, file2);
    }

    public static IntentionAction createFix(@Nullable PsiType type2, @NotNull PsiExpression expression2) {
        class MyFix
        extends LocalQuickFixAndIntentionActionOnPsiElement
        implements HighPriorityAction {
            final /* synthetic */ PsiType val$type;

            protected MyFix(PsiElement psiElement) {
                this.val$type = psiElement;
                super((PsiElement)element);
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                return QuickFixBundle.message("wrap.with.optional.single.parameter.text", new Object[0]);
            }

            public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                startElement.replace((PsiElement)WrapObjectWithOptionalOfNullableFix.getModifiedExpression((PsiExpression)this.getStartElement()));
            }

            public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                return startElement.isValid() && startElement.getManager().isInProject(startElement) && PsiUtil.isLanguageLevel8OrHigher((PsiElement)startElement) && WrapObjectWithOptionalOfNullableFix.areConvertible(((PsiExpression)startElement).getType(), this.val$type);
            }

            @NotNull
            public String getText() {
                return this.getFamilyName();
            }
        }
        return new MyFix((PsiElement)expression2, type2);
    }

    private static boolean areConvertible(@Nullable PsiType exprType, @Nullable PsiType parameterType) {
        if (!(exprType != null && exprType.isValid() && parameterType instanceof PsiClassType && parameterType.isValid())) {
            return false;
        }
        PsiClassType.ClassResolveResult resolve2 = ((PsiClassType)parameterType).resolveGenerics();
        PsiClass resolvedClass = resolve2.getElement();
        if (resolvedClass == null || !"java.util.Optional".equals(resolvedClass.getQualifiedName())) {
            return false;
        }
        Collection values = resolve2.getSubstitutor().getSubstitutionMap().values();
        if (values.size() == 0) {
            return true;
        }
        if (values.size() > 1) {
            return false;
        }
        PsiType optionalTypeParameter = (PsiType)ContainerUtil.getFirstItem(values);
        if (optionalTypeParameter == null) {
            return false;
        }
        return TypeConversionUtil.isAssignable((PsiType)optionalTypeParameter, (PsiType)exprType);
    }

    @NotNull
    private static PsiExpression getModifiedExpression(PsiExpression expression2) {
        PsiElement resolved;
        Project project2 = expression2.getProject();
        PsiMethod toCheckNullability = null;
        if (expression2 instanceof PsiMethodCallExpression) {
            toCheckNullability = ((PsiMethodCallExpression)expression2).resolveMethod();
        } else if (expression2 instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiModifierListOwner) {
            toCheckNullability = (PsiModifierListOwner)resolved;
        }
        Nullness nullability = toCheckNullability == null ? Nullness.NOT_NULL : DfaPsiUtil.getElementNullability(expression2.getType(), (PsiModifierListOwner)toCheckNullability);
        String methodName = nullability == Nullness.NOT_NULL ? "of" : "ofNullable";
        String newExpressionText = "java.util.Optional." + methodName + "(" + expression2.getText() + ")";
        return JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(newExpressionText, (PsiElement)expression2);
    }

    public static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
            return WrapObjectWithOptionalOfNullableFix.getModifiedExpression(expression2);
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            return parameterType.isConvertibleFrom(exprType) || WrapObjectWithOptionalOfNullableFix.areConvertible(exprType, parameterType);
        }

        @Override
        public MethodArgumentFix createFix(PsiExpressionList list, int i2, PsiType toType) {
            return new WrapObjectWithOptionalOfNullableFix(list, i2, toType, this);
        }
    }
}

