/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapStringWithFileFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    public static final MyMethodArgumentFixerFactory REGISTAR = new MyMethodArgumentFixerFactory();
    @Nullable
    private final PsiType myType;

    public WrapStringWithFileFix(@Nullable PsiType type2, @NotNull PsiExpression expression2) {
        super((PsiElement)expression2);
        this.myType = type2;
    }

    @Nls
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("wrap.with.java.io.file.text", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return this.myType != null && this.myType.isValid() && this.myType.equalsToText("java.io.File") && startElement.isValid() && startElement.getManager().isInProject(startElement) && WrapStringWithFileFix.isStringType(startElement);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        startElement.replace(WrapStringWithFileFix.getModifiedExpression(startElement));
    }

    private static boolean isStringType(@NotNull PsiElement expression2) {
        if (!(expression2 instanceof PsiExpression)) {
            return false;
        }
        PsiType type2 = ((PsiExpression)expression2).getType();
        if (type2 == null) {
            return false;
        }
        return type2.equalsToText("java.lang.String");
    }

    private static PsiElement getModifiedExpression(@NotNull PsiElement expression2) {
        return JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText("new java.io.File(" + expression2.getText() + ")", expression2);
    }

    public static class MyMethodArgumentFixerFactory
    extends ArgumentFixerActionFactory {
        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
            return WrapStringWithFileFix.isStringType((PsiElement)expression2) && toType.equalsToText("java.io.File") ? (PsiExpression)WrapStringWithFileFix.getModifiedExpression((PsiElement)expression2) : null;
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            return parameterType.isConvertibleFrom(exprType) || parameterType.equalsToText("java.io.File") && exprType.equalsToText("java.lang.String");
        }

        @Override
        public MethodArgumentFix createFix(PsiExpressionList list, int i2, PsiType toType) {
            return new MyMethodArgumentFix(list, i2, toType, this);
        }
    }

    private static class MyMethodArgumentFix
    extends MethodArgumentFix
    implements HighPriorityAction {
        protected MyMethodArgumentFix(@NotNull PsiExpressionList list, int i2, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
            super(list, i2, toType, fixerActionFactory);
        }

        @Nls
        @NotNull
        public String getText() {
            return this.myArgList.getExpressions().length == 1 ? QuickFixBundle.message("wrap.with.java.io.file.parameter.single.text", new Object[0]) : QuickFixBundle.message("wrap.with.java.io.file.parameter.multiple.text", this.myIndex + 1);
        }

        @Override
        public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
            return PsiUtil.isLanguageLevel8OrHigher((PsiElement)file2) && super.isAvailable(project2, editor, file2);
        }
    }
}

