/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInsight.daemon.quickFix.RenameFileReferenceIntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceQuickFixProvider {
    private FileReferenceQuickFixProvider() {
    }

    @NotNull
    public static List<? extends LocalQuickFix> registerQuickFix(@NotNull FileReference reference) {
        boolean isdirectory;
        PsiFile containingFile;
        FileReferenceSet fileReferenceSet = reference.getFileReferenceSet();
        int index = reference.getIndex();
        if (index < 0) {
            return Collections.emptyList();
        }
        String newFileName = reference.getFileNameToCreate();
        if (newFileName.isEmpty() || newFileName.indexOf(92) != -1 || newFileName.indexOf(42) != -1 || newFileName.indexOf(63) != -1 || SystemInfo.isWindows && newFileName.indexOf(58) != -1) {
            return Collections.emptyList();
        }
        PsiFileSystemItem context = null;
        PsiElement element = reference.getElement();
        PsiFile psiFile = containingFile = element == null ? null : element.getContainingFile();
        if (index > 0) {
            context = fileReferenceSet.getReference(index - 1).resolve();
        } else {
            Collection<PsiFileSystemItem> defaultContexts = fileReferenceSet.getDefaultContexts();
            if (defaultContexts.isEmpty()) {
                return Collections.emptyList();
            }
            Module module2 = containingFile == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
            for (PsiFileSystemItem defaultContext : defaultContexts) {
                VirtualFile virtualFile;
                if (defaultContext == null || (virtualFile = defaultContext.getVirtualFile()) == null || !defaultContext.isDirectory() || !virtualFile.isInLocalFileSystem()) continue;
                if (context == null) {
                    context = defaultContext;
                }
                if (module2 == null || module2 != FileReferenceQuickFixProvider.getModuleForContext(defaultContext)) continue;
                context = defaultContext;
                break;
            }
            if (context == null && ApplicationManager.getApplication().isUnitTestMode()) {
                context = defaultContexts.iterator().next();
            }
        }
        if (context == null) {
            return Collections.emptyList();
        }
        VirtualFile virtualFile = context.getVirtualFile();
        if (virtualFile == null || !virtualFile.isValid()) {
            return Collections.emptyList();
        }
        PsiDirectory directory = context.getManager().findDirectory(virtualFile);
        if (directory == null) {
            return Collections.emptyList();
        }
        if (fileReferenceSet.isCaseSensitive()) {
            PsiFileSystemItem psiElement;
            PsiFileSystemItem psiFileSystemItem = psiElement = containingFile == null ? null : reference.innerSingleResolve(false, containingFile);
            if (psiElement != null) {
                String existingElementName = ((PsiNamedElement)psiElement).getName();
                RenameFileReferenceIntentionAction renameRefAction = new RenameFileReferenceIntentionAction(existingElementName, reference);
                RenameFileFix renameFileFix = new RenameFileFix(newFileName);
                return Arrays.asList(renameRefAction, renameFileFix);
            }
        }
        if (!reference.isLast()) {
            try {
                directory.checkCreateSubdirectory(newFileName);
            }
            catch (IncorrectOperationException ex) {
                return Collections.emptyList();
            }
            isdirectory = true;
        } else {
            FileType ft = FileTypeManager.getInstance().getFileTypeByFileName(newFileName);
            if (ft instanceof UnknownFileType) {
                return Collections.emptyList();
            }
            try {
                directory.checkCreateFile(newFileName);
            }
            catch (IncorrectOperationException ex) {
                return Collections.emptyList();
            }
            isdirectory = false;
        }
        MyCreateFileFix action = new MyCreateFileFix(isdirectory, newFileName, directory, reference);
        return Collections.singletonList(action);
    }

    @Nullable
    private static Module getModuleForContext(@NotNull PsiFileSystemItem context) {
        VirtualFile file2 = context.getVirtualFile();
        return file2 != null ? ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)context.getProject()) : null;
    }

    private static class MyCreateFileFix
    extends CreateFileFix {
        private final boolean isDirectory;
        private final String myNewFileTemplateName;

        public MyCreateFileFix(boolean isdirectory, String newFileName, PsiDirectory directory, FileReference reference) {
            super(isdirectory, newFileName, directory);
            this.isDirectory = isdirectory;
            this.myNewFileTemplateName = this.isDirectory ? null : reference.getNewFileTemplateName();
        }

        @Override
        protected String getFileText() {
            Project project2;
            FileTemplateManager fileTemplateManager;
            FileTemplate template;
            if (!this.isDirectory && this.myNewFileTemplateName != null && (template = this.findTemplate(fileTemplateManager = FileTemplateManager.getInstance(project2 = this.getStartElement().getProject()))) != null) {
                try {
                    return template.getText(fileTemplateManager.getDefaultProperties());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return super.getFileText();
        }

        private FileTemplate findTemplate(FileTemplateManager fileTemplateManager) {
            FileTemplate template = fileTemplateManager.getTemplate(this.myNewFileTemplateName);
            if (template == null) {
                template = fileTemplateManager.findInternalTemplate(this.myNewFileTemplateName);
            }
            return template;
        }

        @Override
        protected void openFile(@NotNull Project project2, PsiDirectory directory, PsiFile newFile, String text) {
            FileTemplateManager fileTemplateManager;
            FileTemplate template;
            super.openFile(project2, directory, newFile, text);
            if (!this.isDirectory && this.myNewFileTemplateName != null && (template = this.findTemplate(fileTemplateManager = FileTemplateManager.getInstance(project2))) != null && template.isLiveTemplateEnabled()) {
                CreateFromTemplateActionBase.startLiveTemplate(newFile);
            }
        }
    }
}

