/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class RenameFileReferenceIntentionAction
implements IntentionAction,
LocalQuickFix {
    private final String myExistingElementName;
    private final FileReference myFileReference;

    public RenameFileReferenceIntentionAction(String existingElementName, FileReference fileReference) {
        this.myExistingElementName = existingElementName;
        this.myFileReference = fileReference;
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"rename.file.reference.text", (Object[])new Object[]{this.myExistingElementName});
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"rename.file.reference.family", (Object[])new Object[0]);
    }

    public void applyFix(final @NotNull Project project2, final @NotNull ProblemDescriptor descriptor) {
        if (this.isAvailable(project2, null, null)) {
            new WriteCommandAction(project2, new PsiFile[0]){

                protected void run(@NotNull Result result2) throws Throwable {
                    RenameFileReferenceIntentionAction.this.invoke(project2, null, descriptor.getPsiElement().getContainingFile());
                }
            }.execute();
        }
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.myFileReference.handleElementRename(this.myExistingElementName);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

