/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLineIndentProvider
extends JavaLikeLangLineIndentProvider {
    private static final HashMap<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP = new HashMap();

    @Override
    @Nullable
    protected SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType tokenType) {
        return (SemanticEditorPosition.SyntaxElement)SYNTAX_MAP.get((Object)tokenType);
    }

    @Override
    public boolean isSuitableForLanguage(@NotNull Language language) {
        return language.isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @Override
    @Nullable
    protected Indent.Type getIndentTypeInBlock(@NotNull Project project2, @Nullable Language language, @NotNull SemanticEditorPosition blockStartPosition) {
        SemanticEditorPosition beforeStart = blockStartPosition.before().beforeOptional(JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
        if (beforeStart.isAt(JavaTokenType.EQ) || beforeStart.isAt(JavaTokenType.RBRACKET) || beforeStart.isAt(JavaTokenType.LPARENTH)) {
            return Indent.Type.CONTINUATION;
        }
        return super.getIndentTypeInBlock(project2, language, blockStartPosition);
    }

    @Override
    protected boolean isInsideForLikeConstruction(SemanticEditorPosition position) {
        return position.isAfterOnSameLine(JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword);
    }

    static {
        SYNTAX_MAP.put((Object)TokenType.WHITE_SPACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
        SYNTAX_MAP.put((Object)JavaTokenType.SEMICOLON, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon);
        SYNTAX_MAP.put((Object)JavaTokenType.LBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace);
        SYNTAX_MAP.put((Object)JavaTokenType.RBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
        SYNTAX_MAP.put((Object)JavaTokenType.LBRACKET, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket);
        SYNTAX_MAP.put((Object)JavaTokenType.RBRACKET, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket);
        SYNTAX_MAP.put((Object)JavaTokenType.RPARENTH, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
        SYNTAX_MAP.put((Object)JavaTokenType.LPARENTH, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis);
        SYNTAX_MAP.put((Object)JavaTokenType.COLON, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon);
        SYNTAX_MAP.put((Object)JavaTokenType.CASE_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase);
        SYNTAX_MAP.put((Object)JavaTokenType.DEFAULT_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault);
        SYNTAX_MAP.put((Object)JavaTokenType.IF_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put((Object)JavaTokenType.ELSE_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword);
        SYNTAX_MAP.put((Object)JavaTokenType.FOR_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword);
        SYNTAX_MAP.put((Object)JavaTokenType.DO_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword);
        SYNTAX_MAP.put((Object)JavaTokenType.C_STYLE_COMMENT, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment);
        SYNTAX_MAP.put((Object)JavaDocTokenType.DOC_COMMENT_START, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.DocBlockStart);
        SYNTAX_MAP.put((Object)JavaDocTokenType.DOC_COMMENT_END, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.DocBlockEnd);
        SYNTAX_MAP.put((Object)JavaTokenType.COMMA, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma);
        SYNTAX_MAP.put((Object)JavaTokenType.END_OF_LINE_COMMENT, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment);
        SYNTAX_MAP.put((Object)JavaTokenType.TRY_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword);
    }
}

