/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.XmlAttributeInsertHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.XmlGtTypedHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.NotNull;

public class XmlEqTypedHandler
extends TypedHandlerDelegate {
    private boolean needToInsertQuotes = false;

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project2, Editor editor, PsiFile file2, FileType fileType) {
        if (c == '=' && WebEditorOptions.getInstance().isInsertQuotesForAttributeValue() && XmlGtTypedHandler.fileContainsXmlLanguage(file2)) {
            PsiElement atParent;
            PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
            PsiElement at = file2.findElementAt(editor.getCaretModel().getOffset() - 1);
            PsiElement psiElement = atParent = at != null ? at.getParent() : null;
            if (atParent instanceof XmlAttribute && ((XmlAttribute)atParent).getValueElement() == null) {
                this.needToInsertQuotes = ((XmlAttribute)atParent).getValueElement() == null;
            }
        }
        return super.beforeCharTyped(c, project2, editor, file2, fileType);
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (this.needToInsertQuotes) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement fileContext = file2.getContext();
            String toInsert = null;
            if (fileContext != null) {
                if (fileContext.getText().startsWith("\"")) {
                    toInsert = "''";
                }
                if (fileContext.getText().startsWith("'")) {
                    toInsert = "\"\"";
                }
            }
            if (toInsert == null) {
                String quote = XmlAttributeInsertHandler.getAttributeQuote(HtmlUtil.hasHtml(file2) || HtmlUtil.supportsXmlTypedHandlers(file2));
                toInsert = quote + quote;
            }
            editor.getDocument().insertString(offset, (CharSequence)toInsert);
            editor.getCaretModel().moveToOffset(offset + toInsert.length() / 2);
            AutoPopupController.getInstance(project2).scheduleAutoPopup(editor);
        }
        this.needToInsertQuotes = false;
        return super.charTyped(c, project2, editor, file2);
    }
}

