/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class EnterBetweenBracesHandler
extends EnterHandlerDelegateAdapter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesHandler");

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int caretOffset = (Integer)caretOffsetRef.get();
        if (!CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int prevCharOffset = CharArrayUtil.shiftBackward((CharSequence)text, (int)(caretOffset - 1), (String)" \t");
        int nextCharOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)" \t");
        if (!(EnterBetweenBracesHandler.isValidOffset(prevCharOffset, text) && EnterBetweenBracesHandler.isValidOffset(nextCharOffset, text) && this.isBracePair(text.charAt(prevCharOffset), text.charAt(nextCharOffset)))) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        if (file2.findElementAt(prevCharOffset) == file2.findElementAt(nextCharOffset)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int line = document.getLineNumber(caretOffset);
        int start = document.getLineStartOffset(line);
        CodeDocumentationUtil.CommentContext commentContext = CodeDocumentationUtil.tryParseCommentContext(file2, text, caretOffset, start);
        String indentInsideJavadoc = EnterBetweenBracesHandler.isInComment(caretOffset, file2) && commentContext.docAsterisk ? CodeDocumentationUtil.getIndentInsideJavadoc(document, caretOffset) : null;
        originalHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        Project project2 = editor.getProject();
        if (indentInsideJavadoc != null && project2 != null && CodeStyleSettingsManager.getSettings((Project)project2).JD_LEADING_ASTERISKS_ARE_ENABLED) {
            document.insertString(editor.getCaretModel().getOffset(), (CharSequence)("*" + indentInsideJavadoc));
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
        try {
            CodeStyleManager.getInstance((Project)file2.getProject()).adjustLineIndent(file2, editor.getCaretModel().getOffset());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return indentInsideJavadoc == null ? EnterHandlerDelegate.Result.Continue : EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    private static boolean isInComment(int offset, PsiFile file2) {
        return PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), PsiComment.class) != null;
    }

    private static boolean isValidOffset(int offset, CharSequence text) {
        return offset >= 0 && offset < text.length();
    }

    protected boolean isBracePair(char c1, char c2) {
        return c1 == '(' && c2 == ')' || c1 == '{' && c2 == '}';
    }
}

