/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class EnterInStringLiteralHandler
extends EnterHandlerDelegateAdapter {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        int caretOffset = (Integer)caretOffsetRef.get();
        int caretAdvance = (Integer)caretAdvanceRef.get();
        if (!EnterInStringLiteralHandler.isInStringLiteral(editor, dataContext, caretOffset)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
        PsiElement psiAtOffset = file2.findElementAt(caretOffset);
        if (psiAtOffset != null && psiAtOffset.getTextOffset() < caretOffset) {
            Document document = editor.getDocument();
            String text = document.getText();
            ASTNode token = psiAtOffset.getNode();
            JavaLikeQuoteHandler quoteHandler = this.getJavaLikeQuoteHandler(editor, psiAtOffset);
            if (quoteHandler != null && quoteHandler.getConcatenatableStringTokenTypes() != null && quoteHandler.getConcatenatableStringTokenTypes().contains(token.getElementType())) {
                TextRange range = token.getTextRange();
                char literalStart = token.getText().charAt(0);
                StringLiteralLexer lexer = new StringLiteralLexer(literalStart, token.getElementType());
                lexer.start((CharSequence)text, range.getStartOffset(), range.getEndOffset());
                while (lexer.getTokenType() != null) {
                    if (lexer.getTokenStart() < caretOffset && caretOffset < lexer.getTokenEnd()) {
                        if (!StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(lexer.getTokenType())) break;
                        caretOffset = lexer.getTokenEnd();
                        break;
                    }
                    lexer.advance();
                }
                if (quoteHandler.needParenthesesAroundConcatenation(psiAtOffset)) {
                    document.insertString(psiAtOffset.getTextRange().getEndOffset(), (CharSequence)")");
                    document.insertString(psiAtOffset.getTextRange().getStartOffset(), (CharSequence)"(");
                    ++caretOffset;
                    ++caretAdvance;
                }
                String insertedFragment = literalStart + " " + quoteHandler.getStringConcatenationOperatorRepresentation();
                document.insertString(caretOffset, (CharSequence)(insertedFragment + " " + literalStart));
                caretOffset += insertedFragment.length();
                caretAdvance = 1;
                CommonCodeStyleSettings langSettings = CodeStyleSettingsManager.getSettings((Project)file2.getProject()).getCommonSettings(file2.getLanguage());
                if (langSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                    --caretOffset;
                    caretAdvance = 3;
                }
                caretOffsetRef.set((Object)caretOffset);
                caretAdvanceRef.set((Object)caretAdvance);
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected JavaLikeQuoteHandler getJavaLikeQuoteHandler(Editor editor, PsiElement psiAtOffset) {
        QuoteHandler fileTypeQuoteHandler = TypedHandler.getQuoteHandler(psiAtOffset.getContainingFile(), editor);
        return fileTypeQuoteHandler instanceof JavaLikeQuoteHandler ? (JavaLikeQuoteHandler)fileTypeQuoteHandler : null;
    }

    private static boolean isInStringLiteral(@NotNull Editor editor, @NotNull DataContext dataContext, int offset) {
        Language language = EnterHandler.getLanguage(dataContext);
        if (offset > 0 && language != null) {
            QuoteHandler quoteHandler = TypedHandler.getLanguageQuoteHandler(language);
            if (quoteHandler == null) {
                LanguageFileType fileType = language.getAssociatedFileType();
                QuoteHandler quoteHandler2 = quoteHandler = fileType != null ? TypedHandler.getQuoteHandlerForType((FileType)fileType) : null;
            }
            if (quoteHandler != null) {
                EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
                HighlighterIterator iterator = highlighter.createIterator(offset - 1);
                return StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(iterator.getTokenType()) || quoteHandler.isInsideLiteral(iterator);
            }
        }
        return false;
    }
}

