/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.fillParagraph;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.editorActions.fillParagraph.LanguageFillParagraphExtension;
import com.intellij.codeInsight.editorActions.fillParagraph.ParagraphFillHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class FillParagraphAction
extends BaseCodeInsightAction
implements DumbAware {
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new Handler();
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        ParagraphFillHandler handler2 = (ParagraphFillHandler)LanguageFillParagraphExtension.INSTANCE.forLanguage(file2.getLanguage());
        return handler2 != null && handler2.isAvailableForFile(file2);
    }

    private static class Handler
    implements CodeInsightActionHandler {
        private Handler() {
        }

        public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
            ParagraphFillHandler paragraphFillHandler = (ParagraphFillHandler)LanguageFillParagraphExtension.INSTANCE.forLanguage(file2.getLanguage());
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = file2.findElementAt(offset);
            if (element != null && paragraphFillHandler != null && paragraphFillHandler.isAvailableForFile(file2) && paragraphFillHandler.isAvailableForElement(element)) {
                paragraphFillHandler.performOnElement(element, editor);
            }
        }
    }
}

