/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveUpDown;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.MoverWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.DependentLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMoveHandler
extends EditorWriteActionHandler {
    protected final boolean isDown;

    public BaseMoveHandler(boolean down) {
        super(true);
        this.isDown = down;
    }

    public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
        MoverWrapper mover;
        Project project2 = editor.getProject();
        assert (project2 != null);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = editor.getDocument();
        documentManager.commitDocument(document);
        PsiFile file2 = BaseMoveHandler.getRoot(documentManager.getPsiFile(document), editor);
        if (file2 != null && (mover = this.getSuitableMover(editor, file2)) != null && mover.getInfo().toMove2 != null) {
            LineRange range = mover.getInfo().toMove;
            if (!(range.startLine <= 0 && !this.isDown || range.endLine >= document.getLineCount() && this.isDown)) {
                mover.move(editor, file2);
            }
        }
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor.isViewer() || editor.isOneLineMode()) {
            return false;
        }
        Project project2 = editor.getProject();
        return project2 != null && !project2.isDisposed();
    }

    @Nullable
    protected abstract MoverWrapper getSuitableMover(@NotNull Editor var1, @NotNull PsiFile var2);

    @Nullable
    private static PsiFile getRoot(PsiFile file2, Editor editor) {
        if (file2 == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            --offset;
        }
        if (offset < 0) {
            return null;
        }
        PsiElement leafElement = file2.findElementAt(offset);
        if (leafElement == null) {
            return null;
        }
        if (leafElement.getLanguage() instanceof DependentLanguage && (leafElement = file2.getViewProvider().findElementAt(offset, file2.getViewProvider().getBaseLanguage())) == null) {
            return null;
        }
        ASTNode node = leafElement.getNode();
        if (node == null) {
            return null;
        }
        return (PsiFile)PsiUtilBase.getRoot((ASTNode)node).getPsi();
    }
}

