/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;

public class DoWhileConditionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof PsiDoWhileStatement) {
            Document doc = editor.getDocument();
            PsiDoWhileStatement stmt = (PsiDoWhileStatement)psiElement;
            if (stmt.getBody() == null || !(stmt.getBody() instanceof PsiBlockStatement) && stmt.getWhileKeyword() == null) {
                int startOffset = stmt.getTextRange().getStartOffset();
                doc.replaceString(startOffset, startOffset + "do".length(), (CharSequence)"do {} while()");
                return;
            }
            if (stmt.getCondition() == null) {
                if (stmt.getWhileKeyword() == null) {
                    int endOffset = stmt.getTextRange().getEndOffset();
                    doc.insertString(endOffset, (CharSequence)"while()");
                } else if (stmt.getLParenth() == null || stmt.getRParenth() == null) {
                    TextRange whileRange = stmt.getWhileKeyword().getTextRange();
                    doc.replaceString(whileRange.getStartOffset(), whileRange.getEndOffset(), (CharSequence)"while()");
                } else {
                    processor2.registerUnresolvedError(stmt.getLParenth().getTextRange().getEndOffset());
                }
            }
        }
    }
}

