/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import java.util.List;

public class LiteralSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        PsiElement parent = e.getParent();
        return LiteralSelectioner.isStringLiteral(e) || LiteralSelectioner.isStringLiteral(parent);
    }

    private static boolean isStringLiteral(PsiElement element) {
        PsiType type2 = element instanceof PsiLiteralExpression ? ((PsiLiteralExpression)element).getType() : null;
        return type2 != null && type2.equalsToText("java.lang.String") && element.getText().startsWith("\"") && element.getText().endsWith("\"");
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        List<TextRange> result2 = super.select(e, editorText, cursorOffset, editor);
        TextRange range = e.getTextRange();
        SelectWordUtil.addWordHonoringEscapeSequences(editorText, range, cursorOffset, (Lexer)new StringLiteralLexer('\"', JavaTokenType.STRING_LITERAL), result2);
        result2.add(new TextRange(range.getStartOffset() + 1, range.getEndOffset() - 1));
        return result2;
    }
}

