/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollapseExpandDocCommentsHandler
implements CodeInsightActionHandler {
    private final boolean myExpand;

    public CollapseExpandDocCommentsHandler(boolean isExpand) {
        this.myExpand = isExpand;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project2);
        foldingManager.updateFoldRegions(editor);
        FoldRegion[] allFoldRegions = editor.getFoldingModel().getAllFoldRegions();
        Runnable processor2 = () -> {
            for (FoldRegion region : allFoldRegions) {
                PsiElement element = EditorFoldingInfo.get(editor).getPsiElement(region);
                if (!(element instanceof PsiDocCommentBase)) continue;
                region.setExpanded(this.myExpand);
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(processor2);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return null;
    }
}

