/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.ElementSignatureProvider;
import com.intellij.codeInsight.folding.impl.GenericElementSignatureProvider;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingPolicy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.FoldingPolicy");
    private static final GenericElementSignatureProvider GENERIC_PROVIDER = new GenericElementSignatureProvider();

    private FoldingPolicy() {
    }

    public static boolean isCollapseByDefault(PsiElement element) {
        Language lang = element.getLanguage();
        FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(lang);
        try {
            return foldingBuilder != null && foldingBuilder.isCollapsedByDefault(element.getNode());
        }
        catch (IndexNotReadyException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    @Nullable
    public static String getSignature(@NotNull PsiElement element) {
        for (ElementSignatureProvider provider2 : (ElementSignatureProvider[])Extensions.getExtensions(ElementSignatureProvider.EP_NAME)) {
            String signature = provider2.getSignature(element);
            if (signature == null) continue;
            return signature;
        }
        return GENERIC_PROVIDER.getSignature(element);
    }

    @Nullable
    public static PsiElement restoreBySignature(@NotNull PsiFile file2, @NotNull String signature) {
        return FoldingPolicy.restoreBySignature(file2, signature, null);
    }

    @Nullable
    public static PsiElement restoreBySignature(@NotNull PsiFile file2, @NotNull String signature, @Nullable StringBuilder processingInfoStorage) {
        for (ElementSignatureProvider provider2 : (ElementSignatureProvider[])Extensions.getExtensions(ElementSignatureProvider.EP_NAME)) {
            PsiElement result2 = provider2.restoreBySignature(file2, signature, processingInfoStorage);
            if (result2 == null) continue;
            return result2;
        }
        return GENERIC_PROVIDER.restoreBySignature(file2, signature, processingInfoStorage);
    }
}

