/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingUpdate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.FoldingUpdate");
    private static final Key<ParameterizedCachedValue<Runnable, Couple<Boolean>>> CODE_FOLDING_KEY = Key.create((String)"code folding");
    private static final Key<String> CODE_FOLDING_FILE_EXTENSION_KEY = Key.create((String)"code folding file extension");
    private static final Comparator<PsiElement> COMPARE_BY_OFFSET_REVERSED = (element, element1) -> {
        int startOffsetDiff = element1.getTextRange().getStartOffset() - element.getTextRange().getStartOffset();
        return startOffsetDiff == 0 ? element1.getTextRange().getEndOffset() - element.getTextRange().getEndOffset() : startOffsetDiff;
    };
    private static final Key<Object> LAST_UPDATE_INJECTED_STAMP_KEY = Key.create((String)"LAST_UPDATE_INJECTED_STAMP_KEY");

    private FoldingUpdate() {
    }

    @Nullable
    static Runnable updateFoldRegions(@NotNull Editor editor, @NotNull PsiFile file2, boolean applyDefaultState, boolean quick) {
        String oldExtension;
        ParameterizedCachedValue value2;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project2 = file2.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project2).isUncommited(document));
        String currentFileExtension = null;
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null) {
            currentFileExtension = virtualFile.getExtension();
        }
        if ((value2 = (ParameterizedCachedValue)editor.getUserData(CODE_FOLDING_KEY)) != null && ((oldExtension = (String)editor.getUserData(CODE_FOLDING_FILE_EXTENSION_KEY)) == null ? currentFileExtension != null : !oldExtension.equals(currentFileExtension))) {
            value2 = null;
            editor.putUserData(CODE_FOLDING_KEY, null);
        }
        editor.putUserData(CODE_FOLDING_FILE_EXTENSION_KEY, (Object)currentFileExtension);
        if (value2 != null && value2.hasUpToDateValue() && !applyDefaultState) {
            return null;
        }
        if (quick) {
            return (Runnable)FoldingUpdate.getUpdateResult(file2, document, true, project2, editor, applyDefaultState).getValue();
        }
        return (Runnable)CachedValuesManager.getManager((Project)project2).getParameterizedCachedValue((UserDataHolder)editor, CODE_FOLDING_KEY, param -> {
            Document document1 = editor.getDocument();
            PsiFile file1 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document1);
            return FoldingUpdate.getUpdateResult(file1, document1, (Boolean)param.first, project2, editor, (Boolean)param.second);
        }, false, (Object)Couple.of((Object)false, (Object)applyDefaultState));
    }

    private static CachedValueProvider.Result<Runnable> getUpdateResult(PsiFile file2, @NotNull Document document, boolean quick, Project project2, Editor editor, boolean applyDefaultState) {
        FoldingMap elementsToFoldMap = FoldingUpdate.getFoldingsFor(file2, document, quick);
        UpdateFoldRegionsOperation operation = new UpdateFoldRegionsOperation(project2, editor, file2, elementsToFoldMap, applyDefaultState ? UpdateFoldRegionsOperation.ApplyDefaultStateMode.EXCEPT_CARET_REGION : UpdateFoldRegionsOperation.ApplyDefaultStateMode.NO, !applyDefaultState, false);
        Runnable runnable2 = () -> editor.getFoldingModel().runBatchFoldingOperationDoNotCollapseCaret((Runnable)operation);
        HashSet<Object> dependencies = new HashSet<Object>();
        dependencies.add(document);
        dependencies.add(editor.getFoldingModel());
        for (FoldingDescriptor descriptor : elementsToFoldMap.values()) {
            dependencies.addAll(descriptor.getDependencies());
        }
        return CachedValueProvider.Result.create((Object)runnable2, (Object[])ArrayUtil.toObjectArray(dependencies));
    }

    @Nullable
    public static Runnable updateInjectedFoldRegions(@NotNull Editor editor, @NotNull PsiFile file2, boolean applyDefaultState) {
        if (file2 instanceof PsiCompiledElement) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project2 = file2.getProject();
        Document document = editor.getDocument();
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)project2).isUncommited(document));
        FoldingModel foldingModel = editor.getFoldingModel();
        long timeStamp = document.getModificationStamp();
        Object lastTimeStamp = editor.getUserData(LAST_UPDATE_INJECTED_STAMP_KEY);
        if (lastTimeStamp instanceof Long && (Long)lastTimeStamp == timeStamp) {
            return null;
        }
        ConcurrentList<DocumentWindow> injectedDocuments = InjectedLanguageUtil.getCachedInjectedDocuments(file2);
        if (injectedDocuments.isEmpty()) {
            return null;
        }
        ArrayList injectedEditors = new ArrayList();
        ArrayList injectedFiles = new ArrayList();
        ArrayList maps = new ArrayList();
        for (DocumentWindow injectedDocument : injectedDocuments) {
            if (!injectedDocument.isValid()) continue;
            InjectedLanguageUtil.enumerate(injectedDocument, file2, (injectedFile, places) -> {
                if (!injectedFile.isValid()) {
                    return;
                }
                Editor injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injectedFile);
                if (!(injectedEditor instanceof EditorWindow)) {
                    return;
                }
                injectedEditors.add((EditorWindow)injectedEditor);
                injectedFiles.add(injectedFile);
                FoldingMap map2 = new FoldingMap();
                maps.add(map2);
                FoldingUpdate.getFoldingsFor(injectedFile, injectedEditor.getDocument(), map2, false);
            });
        }
        return () -> {
            ArrayList<UpdateFoldRegionsOperation> updateOperations = new ArrayList<UpdateFoldRegionsOperation>(injectedEditors.size());
            for (int i = 0; i < injectedEditors.size(); ++i) {
                EditorWindow injectedEditor = (EditorWindow)injectedEditors.get(i);
                PsiFile injectedFile = (PsiFile)injectedFiles.get(i);
                if (!injectedEditor.getDocument().isValid()) continue;
                FoldingMap map2 = (FoldingMap)((Object)((Object)maps.get(i)));
                updateOperations.add(new UpdateFoldRegionsOperation(project2, injectedEditor, injectedFile, map2, applyDefaultState ? UpdateFoldRegionsOperation.ApplyDefaultStateMode.EXCEPT_CARET_REGION : UpdateFoldRegionsOperation.ApplyDefaultStateMode.NO, !applyDefaultState, true));
            }
            foldingModel.runBatchFoldingOperation(() -> {
                for (Runnable operation : updateOperations) {
                    operation.run();
                }
            });
            editor.putUserData(LAST_UPDATE_INJECTED_STAMP_KEY, (Object)timeStamp);
        };
    }

    public static boolean supportsDumbModeFolding(@NotNull Editor editor) {
        PsiFile file2;
        Project project2 = editor.getProject();
        if (project2 != null && (file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument())) != null) {
            return FoldingUpdate.supportsDumbModeFolding(file2);
        }
        return true;
    }

    static boolean supportsDumbModeFolding(@NotNull PsiFile file2) {
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language language : viewProvider.getLanguages()) {
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (foldingBuilder == null || DumbService.isDumbAware((Object)foldingBuilder)) continue;
            return false;
        }
        return true;
    }

    static FoldingMap getFoldingsFor(@NotNull PsiFile file2, @NotNull Document document, boolean quick) {
        FoldingMap foldingMap = new FoldingMap();
        if (file2 instanceof PsiCompiledFile) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
        }
        FoldingUpdate.getFoldingsFor(file2, document, foldingMap, quick);
        return foldingMap;
    }

    private static void getFoldingsFor(@NotNull PsiFile file2, @NotNull Document document, @NotNull FoldingMap elementsToFoldMap, boolean quick) {
        FileViewProvider viewProvider = file2.getViewProvider();
        TextRange docRange = TextRange.from((int)0, (int)document.getTextLength());
        for (Language language : viewProvider.getLanguages()) {
            PsiFile psi = viewProvider.getPsi(language);
            FoldingBuilder foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language);
            if (psi == null || foldingBuilder == null) continue;
            for (FoldingDescriptor descriptor : LanguageFolding.buildFoldingDescriptors((FoldingBuilder)foldingBuilder, (PsiElement)psi, (Document)document, (boolean)quick)) {
                PsiElement psiElement = descriptor.getElement().getPsi();
                if (psiElement == null) {
                    LOG.error("No PSI for folding descriptor " + descriptor);
                    continue;
                }
                if (!docRange.contains(descriptor.getRange())) {
                    FoldingUpdate.diagnoseIncorrectRange(psi, document, language, foldingBuilder, descriptor, psiElement);
                    continue;
                }
                elementsToFoldMap.putValue(psiElement, descriptor);
            }
        }
    }

    private static void diagnoseIncorrectRange(@NotNull PsiFile file2, @NotNull Document document, Language language, FoldingBuilder foldingBuilder, FoldingDescriptor descriptor, PsiElement psiElement) {
        Attachment[] attachmentArray;
        String message2 = "Folding descriptor " + descriptor + " made by " + foldingBuilder + " for " + language + " is outside document range, PSI element: " + psiElement + ", PSI element range: " + psiElement.getTextRange() + "; " + DebugUtil.diagnosePsiDocumentInconsistency(psiElement, document);
        if (ApplicationManager.getApplication().isInternal()) {
            Attachment[] attachmentArray2 = new Attachment[2];
            attachmentArray2[0] = AttachmentFactory.createAttachment(document);
            attachmentArray = attachmentArray2;
            attachmentArray2[1] = new Attachment("psiTree.txt", DebugUtil.psiToString((PsiElement)file2, false, true));
        } else {
            attachmentArray = Attachment.EMPTY_ARRAY;
        }
        LOG.error(message2, attachmentArray);
    }

    static class FoldingMap
    extends MultiMap<PsiElement, FoldingDescriptor> {
        FoldingMap() {
        }

        FoldingMap(FoldingMap map2) {
            super((MultiMap)map2);
        }

        @NotNull
        protected Map<PsiElement, Collection<FoldingDescriptor>> createMap() {
            return new TreeMap<PsiElement, Collection<FoldingDescriptor>>(COMPARE_BY_OFFSET_REVERSED);
        }

        @NotNull
        protected Collection<FoldingDescriptor> createCollection() {
            return new ArrayList<FoldingDescriptor>(1);
        }
    }
}

