/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.AbstractElementSignatureProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.javadoc.PsiDocComment;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaElementSignatureProvider
extends AbstractElementSignatureProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.JavaElementSignatureProvider");

    @Override
    @Nullable
    public String getSignature(@NotNull PsiElement element) {
        PsiFile file2 = element.getContainingFile();
        if (!(file2 instanceof PsiJavaFile)) {
            return null;
        }
        if (element instanceof PsiImportList) {
            if (element.equals(((PsiJavaFile)file2).getImportList())) {
                return "imports";
            }
            return null;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)element;
            PsiElement parent = method2.getParent();
            StringBuilder buffer = new StringBuilder();
            buffer.append("method").append("#");
            String name = method2.getName();
            buffer.append(name);
            buffer.append("#");
            buffer.append(JavaElementSignatureProvider.getChildIndex(method2, parent, name, PsiMethod.class));
            if (parent instanceof PsiClass) {
                String parentSignature = this.getSignature(parent);
                if (parentSignature == null) {
                    return null;
                }
                buffer.append(";");
                buffer.append(parentSignature);
            }
            return buffer.toString();
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            PsiElement parent = aClass.getParent();
            StringBuilder buffer = new StringBuilder();
            buffer.append("class").append("#");
            if (parent instanceof PsiClass || parent instanceof PsiFile) {
                String name = aClass.getName();
                buffer.append(name);
                buffer.append("#");
                buffer.append(JavaElementSignatureProvider.getChildIndex(aClass, parent, name, PsiClass.class));
                if (parent instanceof PsiClass) {
                    String parentSignature = this.getSignature(parent);
                    if (parentSignature == null) {
                        return null;
                    }
                    buffer.append(";");
                    buffer.append(parentSignature);
                }
            } else {
                buffer.append(aClass.getTextRange().getStartOffset());
                buffer.append(":");
                buffer.append(aClass.getTextRange().getEndOffset());
            }
            return buffer.toString();
        }
        if (element instanceof PsiClassInitializer) {
            PsiElement[] children2;
            PsiClassInitializer initializer = (PsiClassInitializer)element;
            PsiElement parent = initializer.getParent();
            StringBuilder buffer = new StringBuilder();
            buffer.append("initializer").append("#");
            int index = 0;
            for (PsiElement child : children2 = parent.getChildren()) {
                if (!(child instanceof PsiClassInitializer)) continue;
                if (child.equals(initializer)) break;
                ++index;
            }
            buffer.append("#");
            buffer.append(index);
            if (parent instanceof PsiClass) {
                String parentSignature = this.getSignature(parent);
                if (parentSignature == null) {
                    return null;
                }
                buffer.append(";");
                buffer.append(parentSignature);
            }
            return buffer.toString();
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            PsiElement parent = field.getParent();
            StringBuilder buffer = new StringBuilder();
            buffer.append("field").append("#");
            String name = field.getName();
            buffer.append(name);
            buffer.append("#");
            buffer.append(JavaElementSignatureProvider.getChildIndex(field, parent, name, PsiField.class));
            if (parent instanceof PsiClass) {
                String parentSignature = this.getSignature(parent);
                if (parentSignature == null) {
                    return null;
                }
                buffer.append(";");
                buffer.append(parentSignature);
            }
            return buffer.toString();
        }
        if (element instanceof PsiDocComment) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("docComment").append(";");
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass || parent instanceof PsiMethod || parent instanceof PsiField)) {
                return null;
            }
            if (!element.equals(((PsiDocCommentOwner)parent).getDocComment())) {
                return null;
            }
            String parentSignature = this.getSignature(parent);
            if (parentSignature == null) {
                return null;
            }
            buffer.append(parentSignature);
            return buffer.toString();
        }
        return null;
    }

    @Override
    protected PsiElement restoreBySignatureTokens(@NotNull PsiFile file2, @NotNull PsiElement parent, @NotNull String type2, @NotNull StringTokenizer tokenizer, @Nullable StringBuilder processingInfoStorage) {
        if (type2.equals("imports")) {
            return file2 instanceof PsiJavaFile ? ((PsiJavaFile)file2).getImportList() : null;
        }
        if (type2.equals("method")) {
            String name = tokenizer.nextToken();
            try {
                int index = Integer.parseInt(tokenizer.nextToken());
                return JavaElementSignatureProvider.restoreElementInternal(parent, name, index, PsiMethod.class);
            }
            catch (NumberFormatException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        if (type2.equals("class")) {
            String name = tokenizer.nextToken();
            PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)file2.getProject());
            if (nameHelper.isIdentifier(name)) {
                int index = 0;
                try {
                    index = Integer.parseInt(tokenizer.nextToken());
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return JavaElementSignatureProvider.restoreElementInternal(parent, name, index, PsiClass.class);
            }
            StringTokenizer tok1 = new StringTokenizer(name, ":");
            int start = Integer.parseInt(tok1.nextToken());
            int end = Integer.parseInt(tok1.nextToken());
            PsiElement element = file2.findElementAt(start);
            if (element != null) {
                TextRange range = element.getTextRange();
                while (range != null && range.getEndOffset() < end) {
                    element = element.getParent();
                    range = element.getTextRange();
                }
                if (range != null && range.getEndOffset() == end && element instanceof PsiClass) {
                    return element;
                }
            }
            return null;
        }
        if (type2.equals("initializer")) {
            try {
                PsiElement[] children2;
                int index = Integer.parseInt(tokenizer.nextToken());
                for (PsiElement child : children2 = parent.getChildren()) {
                    if (!(child instanceof PsiClassInitializer)) continue;
                    if (index == 0) {
                        return child;
                    }
                    --index;
                }
                return null;
            }
            catch (NumberFormatException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        if (type2.equals("field")) {
            String name = tokenizer.nextToken();
            try {
                int index = 0;
                try {
                    index = Integer.parseInt(tokenizer.nextToken());
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return JavaElementSignatureProvider.restoreElementInternal(parent, name, index, PsiField.class);
            }
            catch (NumberFormatException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        if (type2.equals("docComment")) {
            if (parent instanceof PsiClass) {
                return ((PsiClass)parent).getDocComment();
            }
            if (parent instanceof PsiMethod) {
                return ((PsiMethod)parent).getDocComment();
            }
            if (parent instanceof PsiField) {
                return ((PsiField)parent).getDocComment();
            }
            return null;
        }
        return null;
    }
}

