/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInsight.folding.impl.ClosureFolding;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaFoldingBuilderBase
extends CustomFoldingBuilder
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.folding.impl.JavaFoldingBuilder");
    private static final String SMILEY = "<~>";

    private static String getPlaceholderText(@NotNull PsiElement element) {
        if (element instanceof PsiImportList) {
            return "...";
        }
        if (element instanceof PsiMethod || element instanceof PsiClassInitializer || element instanceof PsiClass || element instanceof PsiLambdaExpression) {
            return "{...}";
        }
        if (element instanceof PsiDocComment) {
            return "/**...*/";
        }
        if (element instanceof PsiFile) {
            return "/.../";
        }
        if (element instanceof PsiAnnotation) {
            return "@{...}";
        }
        if (element instanceof PsiReferenceParameterList) {
            return SMILEY;
        }
        if (element instanceof PsiComment) {
            return "//...";
        }
        return "...";
    }

    private static boolean areOnAdjacentLines(@NotNull PsiElement e1, @NotNull PsiElement e2, @NotNull Document document) {
        return document.getLineNumber(e1.getTextRange().getEndOffset()) + 1 == document.getLineNumber(e2.getTextRange().getStartOffset());
    }

    private static boolean isSimplePropertyAccessor(@NotNull PsiMethod method2) {
        PsiExpression expr;
        if (DumbService.isDumb((Project)method2.getProject())) {
            return false;
        }
        PsiCodeBlock body2 = method2.getBody();
        if (body2 == null || body2.getLBrace() == null || body2.getRBrace() == null) {
            return false;
        }
        PsiStatement[] statements = body2.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PsiStatement statement2 = statements[0];
        if (PropertyUtil.isSimplePropertyGetter((PsiMethod)method2)) {
            if (statement2 instanceof PsiReturnStatement) {
                return ((PsiReturnStatement)statement2).getReturnValue() instanceof PsiReferenceExpression;
            }
            return false;
        }
        if (statements.length > 1 && !(statements[1] instanceof PsiReturnStatement)) {
            return false;
        }
        if (statement2 instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement2).getExpression()) instanceof PsiAssignmentExpression) {
            PsiExpression lhs = ((PsiAssignmentExpression)expr).getLExpression();
            PsiExpression rhs = ((PsiAssignmentExpression)expr).getRExpression();
            return lhs instanceof PsiReferenceExpression && rhs instanceof PsiReferenceExpression && !((PsiReferenceExpression)rhs).isQualified() && PropertyUtil.isSimplePropertySetter((PsiMethod)method2);
        }
        return false;
    }

    @Nullable
    private static TextRange getRangeToFold(@NotNull PsiElement element) {
        PsiElement body2;
        if (element instanceof SyntheticElement) {
            return null;
        }
        if (element instanceof PsiMethod) {
            PsiCodeBlock body3 = ((PsiMethod)element).getBody();
            if (body3 == null) {
                return null;
            }
            return body3.getTextRange();
        }
        if (element instanceof PsiClassInitializer) {
            return ((PsiClassInitializer)element).getBody().getTextRange();
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            PsiElement lBrace = aClass.getLBrace();
            if (lBrace == null) {
                return null;
            }
            PsiElement rBrace = aClass.getRBrace();
            if (rBrace == null) {
                return null;
            }
            return new TextRange(lBrace.getTextOffset(), rBrace.getTextOffset() + 1);
        }
        if (element instanceof PsiJavaFile) {
            return JavaFoldingBuilderBase.getFileHeader((PsiJavaFile)element);
        }
        if (element instanceof PsiImportList) {
            PsiImportList list = (PsiImportList)element;
            PsiImportStatementBase[] statements = list.getAllImportStatements();
            if (statements.length == 0) {
                return null;
            }
            PsiElement importKeyword = statements[0].getFirstChild();
            if (importKeyword == null) {
                return null;
            }
            int startOffset = importKeyword.getTextRange().getEndOffset() + 1;
            int endOffset = statements[statements.length - 1].getTextRange().getEndOffset();
            if (!JavaFoldingBuilderBase.hasErrorElementsNearby(element.getContainingFile(), startOffset, endOffset)) {
                return new TextRange(startOffset, endOffset);
            }
        }
        if (element instanceof PsiDocComment) {
            return element.getTextRange();
        }
        if (element instanceof PsiAnnotation) {
            int startOffset = element.getTextRange().getStartOffset();
            PsiElement last = element;
            while (element instanceof PsiAnnotation) {
                last = element;
                element = PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
            }
            return new TextRange(startOffset, last.getTextRange().getEndOffset());
        }
        if (element instanceof PsiLambdaExpression && (body2 = ((PsiLambdaExpression)element).getBody()) instanceof PsiCodeBlock) {
            return body2.getTextRange();
        }
        return null;
    }

    public static boolean hasErrorElementsNearby(@NotNull PsiFile file2, int startOffset, int endOffset) {
        endOffset = CharArrayUtil.shiftForward((CharSequence)file2.getViewProvider().getContents(), (int)endOffset, (String)" \t\n");
        for (PsiElement element : CollectHighlightsUtil.getElementsInRange((PsiElement)file2, startOffset, endOffset)) {
            if (!(element instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static TextRange getFileHeader(@NotNull PsiJavaFile file2) {
        PsiElement first = file2.getFirstChild();
        if (first instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        PsiElement element = first;
        while (element instanceof PsiComment && (element = element.getNextSibling()) instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        if (element == null) {
            return null;
        }
        PsiElement prevSibling = element.getPrevSibling();
        if (prevSibling instanceof PsiWhiteSpace) {
            element = prevSibling;
        }
        if (element.equals(first)) {
            return null;
        }
        return new UnfairTextRange(first.getTextOffset(), element.getTextOffset());
    }

    private static void addAnnotationsToFold(@Nullable PsiModifierList modifierList, @NotNull List<FoldingDescriptor> foldElements, @NotNull Document document) {
        if (modifierList == null) {
            return;
        }
        PsiElement[] children2 = modifierList.getChildren();
        for (int i2 = 0; i2 < children2.length; ++i2) {
            PsiElement nextChild;
            int j;
            PsiElement child = children2[i2];
            if (!(child instanceof PsiAnnotation)) continue;
            JavaFoldingBuilderBase.addToFold(foldElements, child, document, false);
            for (j = i2 + 1; j < children2.length && !((nextChild = children2[j]) instanceof PsiModifier); ++j) {
            }
            i2 = j;
        }
    }

    private static void addCommentFolds(@NotNull PsiComment comment, @NotNull Set<PsiElement> processedComments, @NotNull List<FoldingDescriptor> foldElements) {
        ASTNode node;
        if (processedComments.contains(comment) || comment.getTokenType() != JavaTokenType.END_OF_LINE_COMMENT) {
            return;
        }
        PsiElement end = null;
        boolean containsCustomRegionMarker = JavaFoldingBuilderBase.isCustomRegionElement((PsiElement)comment);
        for (PsiElement current = comment.getNextSibling(); current != null && (node = current.getNode()) != null; current = current.getNextSibling()) {
            IElementType elementType = node.getElementType();
            if (elementType == JavaTokenType.END_OF_LINE_COMMENT) {
                end = current;
                processedComments.add(current);
                containsCustomRegionMarker |= JavaFoldingBuilderBase.isCustomRegionElement((PsiElement)current);
                continue;
            }
            if (elementType != TokenType.WHITE_SPACE) break;
        }
        if (end != null && !containsCustomRegionMarker) {
            foldElements.add(new FoldingDescriptor((PsiElement)comment, new TextRange(comment.getTextRange().getStartOffset(), end.getTextRange().getEndOffset())));
        }
    }

    private static void addMethodGenericParametersFolding(@NotNull PsiMethodCallExpression expression2, @NotNull List<FoldingDescriptor> foldElements, @NotNull Document document, boolean quick) {
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        PsiReferenceParameterList list = methodExpression.getParameterList();
        if (list == null || list.getTextLength() <= 5) {
            return;
        }
        PsiMethodCallExpression element = expression2;
        while (true) {
            if (!quick && !JavaFoldingBuilderBase.resolvesCorrectly(element.getMethodExpression())) {
                return;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiExpressionList) || !(parent.getParent() instanceof PsiMethodCallExpression)) break;
            element = (PsiMethodCallExpression)parent.getParent();
        }
        JavaFoldingBuilderBase.addTypeParametersFolding(foldElements, document, list, 3, quick);
    }

    private static boolean resolvesCorrectly(@NotNull PsiReferenceExpression expression2) {
        for (JavaResolveResult result2 : expression2.multiResolve(true)) {
            if (result2.isValidResult()) continue;
            return false;
        }
        return true;
    }

    private static void addGenericParametersFolding(@NotNull PsiNewExpression expression2, @NotNull List<FoldingDescriptor> foldElements, @NotNull Document document, boolean quick) {
        PsiReferenceParameterList list;
        PsiAnonymousClass anonymousClass;
        PsiElement parent = expression2.getParent();
        if (!(parent instanceof PsiVariable)) {
            return;
        }
        PsiType declType = ((PsiVariable)parent).getType();
        if (!(declType instanceof PsiClassReferenceType)) {
            return;
        }
        Object[] parameters2 = ((PsiClassType)declType).getParameters();
        if (parameters2.length == 0) {
            return;
        }
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
        if (classReference2 == null && (anonymousClass = expression2.getAnonymousClass()) != null) {
            classReference2 = anonymousClass.getBaseClassReference();
            if (quick || ClosureFolding.seemsLikeLambda(anonymousClass.getSuperClass(), (PsiElement)anonymousClass)) {
                return;
            }
        }
        if (classReference2 != null && (list = classReference2.getParameterList()) != null) {
            PsiJavaCodeReferenceElement declReference;
            PsiReferenceParameterList declList;
            if (quick ? (declList = (declReference = ((PsiClassReferenceType)declType).getReference()).getParameterList()) == null || !list.getText().equals(declList.getText()) : !Arrays.equals(list.getTypeArguments(), parameters2)) {
                return;
            }
            JavaFoldingBuilderBase.addTypeParametersFolding(foldElements, document, list, 5, quick);
        }
    }

    private static void addTypeParametersFolding(@NotNull List<FoldingDescriptor> foldElements, @NotNull Document document, @NotNull PsiReferenceParameterList list, int ifLongerThan, boolean quick) {
        String text;
        if (!quick) {
            for (PsiType type2 : list.getTypeArguments()) {
                if (!type2.isValid()) {
                    return;
                }
                if (!(type2 instanceof PsiClassType) && !(type2 instanceof PsiArrayType) || PsiUtil.resolveClassInType((PsiType)type2) != null) continue;
                return;
            }
        }
        if ((text = list.getText()).startsWith("<") && text.endsWith(">") && text.length() > ifLongerThan) {
            TextRange range = list.getTextRange();
            JavaFoldingBuilderBase.addFoldRegion(foldElements, (PsiElement)list, document, true, range);
        }
    }

    protected abstract boolean shouldShowExplicitLambdaType(@NotNull PsiAnonymousClass var1, @NotNull PsiNewExpression var2);

    private static boolean addToFold(@NotNull List<FoldingDescriptor> list, @NotNull PsiElement elementToFold, @NotNull Document document, boolean allowOneLiners) {
        PsiUtilCore.ensureValid((PsiElement)elementToFold);
        TextRange range = JavaFoldingBuilderBase.getRangeToFold(elementToFold);
        return range != null && JavaFoldingBuilderBase.addFoldRegion(list, elementToFold, document, allowOneLiners, range);
    }

    private static boolean addFoldRegion(@NotNull List<FoldingDescriptor> list, @NotNull PsiElement elementToFold, @NotNull Document document, boolean allowOneLiners, @NotNull TextRange range) {
        TextRange fileRange = elementToFold.getContainingFile().getTextRange();
        if (range.equals((Object)fileRange)) {
            return false;
        }
        LOG.assertTrue(range.getStartOffset() >= 0 && range.getEndOffset() <= fileRange.getEndOffset());
        if (range.getStartOffset() < 0 || range.getEndOffset() > fileRange.getEndOffset()) {
            return false;
        }
        if (!allowOneLiners) {
            int endLine;
            int startLine = document.getLineNumber(range.getStartOffset());
            if (startLine < (endLine = document.getLineNumber(range.getEndOffset() - 1)) && range.getLength() > 1) {
                list.add(new FoldingDescriptor(elementToFold, range));
                return true;
            }
            return false;
        }
        if (range.getLength() > JavaFoldingBuilderBase.getPlaceholderText(elementToFold).length()) {
            list.add(new FoldingDescriptor(elementToFold, range));
            return true;
        }
        return false;
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        TextRange classes2;
        TextRange rangeToFold;
        PsiImportStatementBase[] statements;
        if (!(root instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile file2 = (PsiJavaFile)root;
        PsiImportList importList = file2.getImportList();
        if (importList != null && (statements = importList.getAllImportStatements()).length > 1 && (rangeToFold = JavaFoldingBuilderBase.getRangeToFold((PsiElement)importList)) != null && rangeToFold.getLength() > 1) {
            FoldingDescriptor descriptor = new FoldingDescriptor((PsiElement)importList, rangeToFold);
            descriptor.setCanBeRemovedWhenCollapsed(true);
            descriptors.add(descriptor);
        }
        for (TextRange aClass : classes2 = file2.getClasses()) {
            ProgressManager.checkCanceled();
            ProgressIndicatorProvider.checkCanceled();
            this.addElementsToFold(descriptors, (PsiClass)aClass, document, true, quick);
        }
        TextRange range = JavaFoldingBuilderBase.getFileHeader(file2);
        if (range != null && range.getLength() > 1 && document.getLineNumber(range.getEndOffset()) > document.getLineNumber(range.getStartOffset())) {
            ASTNode node;
            PsiJavaFile anchorElementToUse = file2;
            PsiElement candidate = file2.getFirstChild();
            if (candidate != null && candidate.getTextRange().equals((Object)range) && (node = candidate.getNode()) != null && node.getElementType() == JavaDocElementType.DOC_COMMENT) {
                anchorElementToUse = candidate;
            }
            descriptors.add(new FoldingDescriptor((PsiElement)anchorElementToUse, range));
        }
    }

    private void addElementsToFold(@NotNull List<FoldingDescriptor> list, @NotNull PsiClass aClass, @NotNull Document document, boolean foldJavaDocs, boolean quick) {
        PsiDocComment docComment;
        if (!(aClass.getParent() instanceof PsiJavaFile) || ((PsiJavaFile)aClass.getParent()).getClasses().length > 1) {
            JavaFoldingBuilderBase.addToFold(list, (PsiElement)aClass, document, true);
        }
        if (foldJavaDocs && (docComment = aClass.getDocComment()) != null) {
            JavaFoldingBuilderBase.addToFold(list, (PsiElement)docComment, document, true);
        }
        JavaFoldingBuilderBase.addAnnotationsToFold(aClass.getModifierList(), list, document);
        PsiElement[] children2 = aClass.getChildren();
        HashSet<PsiElement> processedComments = new HashSet<PsiElement>();
        for (PsiElement child : children2) {
            ProgressIndicatorProvider.checkCanceled();
            if (child instanceof PsiMethod) {
                PsiCodeBlock body2;
                PsiMethod method2 = (PsiMethod)child;
                boolean oneLiner = this.addOneLineMethodFolding(list, method2);
                if (!oneLiner) {
                    JavaFoldingBuilderBase.addToFold(list, (PsiElement)method2, document, true);
                }
                JavaFoldingBuilderBase.addAnnotationsToFold(method2.getModifierList(), list, document);
                if (foldJavaDocs && (docComment = method2.getDocComment()) != null) {
                    JavaFoldingBuilderBase.addToFold(list, (PsiElement)docComment, document, true);
                }
                if ((body2 = method2.getBody()) == null || oneLiner) continue;
                this.addCodeBlockFolds((PsiElement)body2, list, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiField) {
                PsiField field = (PsiField)child;
                if (foldJavaDocs && (docComment = field.getDocComment()) != null) {
                    JavaFoldingBuilderBase.addToFold(list, (PsiElement)docComment, document, true);
                }
                JavaFoldingBuilderBase.addAnnotationsToFold(field.getModifierList(), list, document);
                PsiExpression initializer = field.getInitializer();
                if (initializer != null) {
                    this.addCodeBlockFolds((PsiElement)initializer, list, processedComments, document, quick);
                    continue;
                }
                if (!(field instanceof PsiEnumConstant)) continue;
                this.addCodeBlockFolds((PsiElement)field, list, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClassInitializer) {
                PsiClassInitializer initializer = (PsiClassInitializer)child;
                JavaFoldingBuilderBase.addToFold(list, (PsiElement)initializer, document, true);
                this.addCodeBlockFolds((PsiElement)initializer, list, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClass) {
                this.addElementsToFold(list, (PsiClass)child, document, true, quick);
                continue;
            }
            if (!(child instanceof PsiComment)) continue;
            JavaFoldingBuilderBase.addCommentFolds((PsiComment)child, processedComments, list);
        }
    }

    private boolean addOneLineMethodFolding(@NotNull List<FoldingDescriptor> descriptorList, @NotNull PsiMethod method2) {
        if (!JavaCodeFoldingSettings.getInstance().isCollapseOneLineMethods()) {
            return false;
        }
        Document document = method2.getContainingFile().getViewProvider().getDocument();
        PsiCodeBlock body2 = method2.getBody();
        PsiIdentifier nameIdentifier = method2.getNameIdentifier();
        if (body2 == null || document == null || nameIdentifier == null) {
            return false;
        }
        if (document.getLineNumber(nameIdentifier.getTextRange().getStartOffset()) != document.getLineNumber(method2.getParameterList().getTextRange().getEndOffset())) {
            return false;
        }
        PsiJavaToken lBrace = body2.getLBrace();
        PsiJavaToken rBrace = body2.getRBrace();
        PsiStatement[] statements = body2.getStatements();
        if (lBrace == null || rBrace == null || statements.length != 1) {
            return false;
        }
        PsiStatement statement2 = statements[0];
        if (statement2.textContains('\n')) {
            return false;
        }
        if (!JavaFoldingBuilderBase.areOnAdjacentLines((PsiElement)lBrace, (PsiElement)statement2, document) || !JavaFoldingBuilderBase.areOnAdjacentLines((PsiElement)statement2, (PsiElement)rBrace, document)) {
            return false;
        }
        int leftStart = method2.getParameterList().getTextRange().getEndOffset();
        int bodyStart = body2.getTextRange().getStartOffset();
        if (bodyStart > leftStart && !StringUtil.isEmptyOrSpaces((CharSequence)document.getCharsSequence().subSequence(leftStart + 1, bodyStart))) {
            return false;
        }
        int leftEnd = statement2.getTextRange().getStartOffset();
        int rightStart = statement2.getTextRange().getEndOffset();
        int rightEnd = body2.getTextRange().getEndOffset();
        if (leftEnd <= leftStart + 1 || rightEnd <= rightStart + 1) {
            return false;
        }
        String leftText = " { ";
        String rightText = " }";
        if (!this.fitsRightMargin((PsiElement)method2, document, leftStart, rightEnd, rightStart - leftEnd + leftText.length() + rightText.length())) {
            return false;
        }
        FoldingGroup group = FoldingGroup.newGroup((String)"one-liner");
        descriptorList.add(new NamedFoldingDescriptor((PsiElement)lBrace, leftStart, leftEnd, group, leftText));
        descriptorList.add(new NamedFoldingDescriptor((PsiElement)rBrace, rightStart, rightEnd, group, rightText));
        return true;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        return JavaFoldingBuilderBase.getPlaceholderText(SourceTreeToPsiMap.treeElementToPsi(node));
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        PsiElement element = SourceTreeToPsiMap.treeElementToPsi(node);
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        if (element instanceof PsiNewExpression || element instanceof PsiJavaToken && element.getParent() instanceof PsiAnonymousClass) {
            return settings.isCollapseLambdas();
        }
        if (element instanceof PsiJavaToken && element.getParent() instanceof PsiCodeBlock && element.getParent().getParent() instanceof PsiMethod) {
            return settings.isCollapseOneLineMethods();
        }
        if (element instanceof PsiReferenceParameterList) {
            return settings.isCollapseConstructorGenericParameters();
        }
        if (element instanceof PsiImportList) {
            return settings.isCollapseImports();
        }
        if (element instanceof PsiMethod || element instanceof PsiClassInitializer || element instanceof PsiCodeBlock) {
            if (element instanceof PsiMethod) {
                if (!settings.isCollapseAccessors() && !settings.isCollapseMethods()) {
                    return false;
                }
                if (JavaFoldingBuilderBase.isSimplePropertyAccessor((PsiMethod)element)) {
                    return settings.isCollapseAccessors();
                }
            }
            return settings.isCollapseMethods();
        }
        if (element instanceof PsiAnonymousClass) {
            return settings.isCollapseAnonymousClasses();
        }
        if (element instanceof PsiClass) {
            return !(element.getParent() instanceof PsiFile) && settings.isCollapseInnerClasses();
        }
        if (element instanceof PsiDocComment) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiJavaFile) {
                if (((PsiJavaFile)parent).getName().equals("package-info.java")) {
                    return false;
                }
                PsiElement firstChild = parent.getFirstChild();
                if (firstChild instanceof PsiWhiteSpace) {
                    firstChild = firstChild.getNextSibling();
                }
                if (element.equals(firstChild)) {
                    return settings.isCollapseFileHeader();
                }
            }
            return settings.isCollapseJavadocs();
        }
        if (element instanceof PsiJavaFile) {
            return settings.isCollapseFileHeader();
        }
        if (element instanceof PsiAnnotation) {
            return settings.isCollapseAnnotations();
        }
        if (element instanceof PsiComment) {
            return settings.isCollapseEndOfLineComments();
        }
        if (element instanceof PsiLambdaExpression) {
            return settings.isCollapseAnonymousClasses();
        }
        LOG.error("Unknown element:" + element);
        return false;
    }

    private void addCodeBlockFolds(@NotNull PsiElement scope, final @NotNull List<FoldingDescriptor> foldElements, final @NotNull Set<PsiElement> processedComments, final @NotNull Document document, final boolean quick) {
        final boolean dumb = DumbService.isDumb((Project)scope.getProject());
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
                if (dumb || !JavaFoldingBuilderBase.this.addClosureFolding(aClass, document, foldElements, processedComments, quick)) {
                    JavaFoldingBuilderBase.addToFold(foldElements, (PsiElement)aClass, document, true);
                    JavaFoldingBuilderBase.this.addElementsToFold(foldElements, aClass, document, false, quick);
                }
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                if (!dumb) {
                    JavaFoldingBuilderBase.addMethodGenericParametersFolding(expression2, foldElements, document, quick);
                }
                super.visitMethodCallExpression(expression2);
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                if (!dumb) {
                    JavaFoldingBuilderBase.addGenericParametersFolding(expression2, foldElements, document, quick);
                }
                super.visitNewExpression(expression2);
            }

            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                PsiElement body2 = expression2.getBody();
                if (body2 instanceof PsiCodeBlock) {
                    JavaFoldingBuilderBase.addToFold(foldElements, (PsiElement)expression2, document, true);
                }
                super.visitLambdaExpression(expression2);
            }

            public void visitComment(PsiComment comment) {
                JavaFoldingBuilderBase.addCommentFolds(comment, processedComments, foldElements);
                super.visitComment(comment);
            }
        });
    }

    private boolean addClosureFolding(@NotNull PsiClass aClass, @NotNull Document document, @NotNull List<FoldingDescriptor> foldElements, @NotNull Set<PsiElement> processedComments, boolean quick) {
        if (!JavaCodeFoldingSettings.getInstance().isCollapseLambdas()) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            List<NamedFoldingDescriptor> descriptors;
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            ClosureFolding closureFolding = ClosureFolding.prepare(anonymousClass, quick, this);
            List<NamedFoldingDescriptor> list = descriptors = closureFolding == null ? null : closureFolding.process(document);
            if (descriptors != null) {
                foldElements.addAll(descriptors);
                this.addCodeBlockFolds((PsiElement)closureFolding.methodBody, foldElements, processedComments, document, quick);
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected String rightArrow() {
        return "->";
    }

    boolean fitsRightMargin(@NotNull PsiElement element, @NotNull Document document, int foldingStart, int foldingEnd, int collapsedLength) {
        int beforeLength = foldingStart - document.getLineStartOffset(document.getLineNumber(foldingStart));
        int afterLength = document.getLineEndOffset(document.getLineNumber(foldingEnd)) - foldingEnd;
        return this.isBelowRightMargin(element.getProject(), beforeLength + collapsedLength + afterLength);
    }

    protected abstract boolean isBelowRightMargin(@NotNull Project var1, int var2);

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        return node.getElementType() == JavaTokenType.END_OF_LINE_COMMENT;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        IElementType nodeType = node.getElementType();
        if (nodeType == JavaElementType.CLASS) {
            ASTNode parent = node.getTreeParent();
            return parent == null || parent.getElementType() != JavaElementType.CLASS;
        }
        return nodeType == JavaElementType.CODE_BLOCK;
    }
}

