/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.EqualsHashCodeTemplatesManager;
import com.intellij.codeInsight.generation.GenerateEqualsHandler;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.java.generate.GenerationUtil;

public class GenerateEqualsHelper
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateEqualsHelper");
    @NonNls
    private static final String INSTANCE_NAME = "instanceBaseName";
    @NonNls
    private static final String BASE_PARAM_NAME = "baseParamName";
    @NonNls
    private static final String SUPER_PARAM_NAME = "superParamName";
    @NonNls
    private static final String SUPER_HAS_EQUALS = "superHasEquals";
    @NonNls
    private static final String CHECK_PARAMETER_WITH_INSTANCEOF = "checkParameterWithInstanceof";
    @NonNls
    private static final String SUPER_HAS_HASH_CODE = "superHasHashCode";
    private final PsiClass myClass;
    private final PsiField[] myEqualsFields;
    private final PsiField[] myHashCodeFields;
    private final HashSet<PsiField> myNonNullSet;
    private final PsiElementFactory myFactory;
    private final boolean mySuperHasHashCode;
    private final CodeStyleManager myCodeStyleManager;
    private final JavaCodeStyleManager myJavaCodeStyleManager;
    private final Project myProject;
    private final boolean myCheckParameterWithInstanceof;
    private final boolean myUseAccessors;

    public GenerateEqualsHelper(Project project2, PsiClass aClass, PsiField[] equalsFields, PsiField[] hashCodeFields, PsiField[] nonNullFields, boolean useInstanceofToCheckParameterType) {
        this(project2, aClass, equalsFields, hashCodeFields, nonNullFields, useInstanceofToCheckParameterType, false);
    }

    public GenerateEqualsHelper(Project project2, PsiClass aClass, PsiField[] equalsFields, PsiField[] hashCodeFields, PsiField[] nonNullFields, boolean useInstanceofToCheckParameterType, boolean useAccessors) {
        this.myClass = aClass;
        this.myEqualsFields = equalsFields;
        this.myHashCodeFields = hashCodeFields;
        this.myProject = project2;
        this.myCheckParameterWithInstanceof = useInstanceofToCheckParameterType;
        this.myUseAccessors = useAccessors;
        this.myNonNullSet = new HashSet();
        ContainerUtil.addAll(this.myNonNullSet, (Object[])nonNullFields);
        PsiManager manager = PsiManager.getInstance((Project)project2);
        this.myFactory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        this.mySuperHasHashCode = this.superMethodExists(GenerateEqualsHelper.getHashCodeSignature());
        this.myCodeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        this.myJavaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)manager.getProject());
    }

    private static boolean shouldAddOverrideAnnotation(PsiElement context) {
        CodeStyleSettings style = CodeStyleSettingsManager.getSettings((Project)context.getProject());
        return style.INSERT_OVERRIDE_ANNOTATION && PsiUtil.isLanguageLevel5OrHigher((PsiElement)context);
    }

    @Override
    public void run() {
        try {
            Collection<PsiMethod> members = this.generateMembers();
            for (PsiElement psiElement : members) {
                this.myClass.add(psiElement);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public Collection<PsiMethod> generateMembers() throws IncorrectOperationException {
        PsiMethod equals = null;
        if (this.myEqualsFields != null && GenerateEqualsHandler.needToGenerateMethod(GenerateEqualsHelper.findMethod(this.myClass, GenerateEqualsHelper.getEqualsSignature(this.myProject, this.myClass.getResolveScope())))) {
            equals = this.createEquals();
        }
        PsiMethod hashCode = null;
        if (this.myHashCodeFields != null && GenerateEqualsHandler.needToGenerateMethod(GenerateEqualsHelper.findMethod(this.myClass, GenerateEqualsHelper.getHashCodeSignature()))) {
            if (this.myHashCodeFields.length > 0) {
                hashCode = this.createHashCode();
            } else if (!this.mySuperHasHashCode) {
                String text = "";
                if (GenerateEqualsHelper.shouldAddOverrideAnnotation((PsiElement)this.myClass)) {
                    text = text + "@Override\n";
                }
                text = text + "public int hashCode() {\nreturn 0;\n}";
                PsiMethod trivialHashCode = this.myFactory.createMethodFromText(text, null);
                hashCode = (PsiMethod)this.myCodeStyleManager.reformat((PsiElement)trivialHashCode);
            }
        }
        if (hashCode != null && equals != null) {
            return Arrays.asList(equals, hashCode);
        }
        if (equals != null) {
            return Collections.singletonList(equals);
        }
        if (hashCode != null) {
            return Collections.singletonList(hashCode);
        }
        return Collections.emptyList();
    }

    public static Map<String, PsiType> getEqualsImplicitVars(Project project2) {
        LinkedHashMap<String, PsiType> map2 = new LinkedHashMap<String, PsiType>();
        PsiPrimitiveType stringType = project2 != null ? PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project2), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2)) : PsiType.NULL;
        map2.put(INSTANCE_NAME, (PsiType)stringType);
        map2.put(BASE_PARAM_NAME, (PsiType)stringType);
        map2.put(SUPER_PARAM_NAME, (PsiType)stringType);
        map2.put(CHECK_PARAMETER_WITH_INSTANCEOF, (PsiType)PsiType.BOOLEAN);
        map2.put(SUPER_HAS_EQUALS, (PsiType)PsiType.BOOLEAN);
        return map2;
    }

    public static Map<String, PsiType> getHashCodeImplicitVars() {
        LinkedHashMap<String, PsiType> map2 = new LinkedHashMap<String, PsiType>();
        map2.put(SUPER_HAS_HASH_CODE, (PsiType)PsiType.BOOLEAN);
        return map2;
    }

    private PsiMethod createEquals() throws IncorrectOperationException {
        PsiMethod result2;
        StringBuilder buffer = new StringBuilder();
        CodeStyleSettings styleSettings = CodeStyleSettingsManager.getSettings((Project)this.myProject);
        ArrayList equalsFields = new ArrayList();
        ContainerUtil.addAll(equalsFields, (Object[])this.myEqualsFields);
        Collections.sort(equalsFields, EqualsFieldsComparator.INSTANCE);
        HashMap contextMap = new HashMap();
        PsiClassType classType = JavaPsiFacade.getElementFactory((Project)this.myClass.getProject()).createType(this.myClass);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myClass.getProject());
        String[] nameSuggestions = codeStyleManager.suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, null, (PsiType)classType).names;
        String instanceBaseName = nameSuggestions.length > 0 && nameSuggestions[0].length() < 10 ? nameSuggestions[0] : "that";
        contextMap.put((Object)INSTANCE_NAME, (Object)instanceBaseName);
        PsiClassType objectType = PsiType.getJavaLangObject((PsiManager)this.myClass.getManager(), (GlobalSearchScope)this.myClass.getResolveScope());
        nameSuggestions = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)objectType).names;
        String objectBaseName = nameSuggestions.length > 0 ? nameSuggestions[0] : "object";
        contextMap.put((Object)BASE_PARAM_NAME, (Object)objectBaseName);
        MethodSignature equalsSignature = GenerateEqualsHelper.getEqualsSignature(this.myProject, this.myClass.getResolveScope());
        PsiMethod superEquals = MethodSignatureUtil.findMethodBySignature((PsiClass)this.myClass, (MethodSignature)equalsSignature, (boolean)true);
        if (superEquals != null) {
            contextMap.put((Object)SUPER_PARAM_NAME, (Object)superEquals.getParameterList().getParameters()[0].getName());
        }
        contextMap.put((Object)SUPER_HAS_EQUALS, (Object)this.superMethodExists(equalsSignature));
        contextMap.put((Object)CHECK_PARAMETER_WITH_INSTANCEOF, (Object)this.myCheckParameterWithInstanceof);
        String methodText = GenerationUtil.velocityGenerateCode(this.myClass, equalsFields, this.myNonNullSet, (Map<String, String>)new HashMap(), (Map<String, Object>)contextMap, EqualsHashCodeTemplatesManager.getInstance().getDefaultEqualsTemplate().getTemplate(), 0, false, this.myUseAccessors);
        buffer.append(methodText);
        try {
            result2 = this.myFactory.createMethodFromText(buffer.toString(), (PsiElement)this.myClass);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        PsiParameter[] parameters2 = result2.getParameterList().getParameters();
        if (parameters2.length != 1) {
            return null;
        }
        PsiParameter parameter = parameters2[0];
        PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)styleSettings.GENERATE_FINAL_PARAMETERS);
        PsiMethod method2 = (PsiMethod)this.myCodeStyleManager.reformat((PsiElement)result2);
        if (superEquals != null) {
            OverrideImplementUtil.annotateOnOverrideImplement(method2, this.myClass, superEquals);
        }
        method2 = (PsiMethod)this.myJavaCodeStyleManager.shortenClassReferences((PsiElement)method2);
        return method2;
    }

    private boolean superMethodExists(MethodSignature methodSignature) {
        LOG.assertTrue(this.myClass.isValid());
        PsiMethod superEquals = MethodSignatureUtil.findMethodBySignature((PsiClass)this.myClass, (MethodSignature)methodSignature, (boolean)true);
        if (superEquals == null) {
            return true;
        }
        if (superEquals.hasModifierProperty("abstract")) {
            return false;
        }
        return !"java.lang.Object".equals(superEquals.getContainingClass().getQualifiedName());
    }

    private PsiMethod createHashCode() throws IncorrectOperationException {
        PsiMethod hashCode;
        StringBuilder buffer = new StringBuilder();
        HashMap contextMap = new HashMap();
        contextMap.put((Object)SUPER_HAS_HASH_CODE, (Object)this.mySuperHasHashCode);
        String methodText = GenerationUtil.velocityGenerateCode(this.myClass, Arrays.asList(this.myHashCodeFields), this.myNonNullSet, (Map<String, String>)new HashMap(), (Map<String, Object>)contextMap, EqualsHashCodeTemplatesManager.getInstance().getDefaultHashcodeTemplate().getTemplate(), 0, false, this.myUseAccessors);
        buffer.append(methodText);
        try {
            hashCode = this.myFactory.createMethodFromText(buffer.toString(), null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        PsiMethod superHashCode = MethodSignatureUtil.findMethodBySignature((PsiClass)this.myClass, (MethodSignature)GenerateEqualsHelper.getHashCodeSignature(), (boolean)true);
        if (superHashCode != null) {
            OverrideImplementUtil.annotateOnOverrideImplement(hashCode, this.myClass, superHashCode);
        }
        hashCode = (PsiMethod)this.myJavaCodeStyleManager.shortenClassReferences((PsiElement)hashCode);
        return (PsiMethod)this.myCodeStyleManager.reformat((PsiElement)hashCode);
    }

    public void invoke() {
        ApplicationManager.getApplication().runWriteAction((Runnable)this);
    }

    static PsiMethod findMethod(PsiClass aClass, MethodSignature signature) {
        return MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)signature, (boolean)false);
    }

    public static boolean isArrayOfObjects(PsiType aType) {
        if (!(aType instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)aType).getComponentType();
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)componentType);
        if (psiClass == null) {
            return false;
        }
        String qName = psiClass.getQualifiedName();
        return "java.lang.Object".equals(qName);
    }

    public static MethodSignature getHashCodeSignature() {
        return MethodSignatureUtil.createMethodSignature((String)"hashCode", (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    public static MethodSignature getEqualsSignature(Project project2, GlobalSearchScope scope) {
        PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project2), (GlobalSearchScope)scope);
        return MethodSignatureUtil.createMethodSignature((String)"equals", (PsiType[])new PsiType[]{javaLangObject}, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    static class EqualsFieldsComparator
    implements Comparator<PsiField> {
        public static final EqualsFieldsComparator INSTANCE = new EqualsFieldsComparator();

        EqualsFieldsComparator() {
        }

        @Override
        public int compare(PsiField f1, PsiField f2) {
            if (f1.getType() instanceof PsiPrimitiveType && !(f2.getType() instanceof PsiPrimitiveType)) {
                return -1;
            }
            if (!(f1.getType() instanceof PsiPrimitiveType) && f2.getType() instanceof PsiPrimitiveType) {
                return 1;
            }
            return PsiUtilCore.compareElementsByPosition((PsiElement)f1, (PsiElement)f2);
        }
    }
}

