/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.EncapsulatableClassMember;
import com.intellij.codeInsight.generation.GenerateAccessorProviderRegistrar;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.exception.GenerateCodeException;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.template.TemplatesManager;
import org.jetbrains.java.generate.view.TemplatesPanel;

public abstract class GenerateGetterSetterHandlerBase
extends GenerateMembersHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateGetterSetterHandlerBase");

    public GenerateGetterSetterHandlerBase(String chooserTitle) {
        super(chooserTitle);
    }

    @Override
    protected boolean hasMembers(@NotNull PsiClass aClass) {
        return !GenerateAccessorProviderRegistrar.getEncapsulatableClassMembers(aClass).isEmpty();
    }

    @Override
    protected String getHelpId() {
        return "Getter and Setter Templates Dialog";
    }

    @Override
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project2, Editor editor) {
        ClassMember[] allMembers = this.getAllOriginalMembers(aClass);
        if (allMembers == null) {
            HintManager.getInstance().showErrorHint(editor, this.getNothingFoundMessage());
            return null;
        }
        if (allMembers.length == 0) {
            HintManager.getInstance().showErrorHint(editor, this.getNothingAcceptedMessage());
            return null;
        }
        return this.chooseMembers(allMembers, false, false, project2, editor);
    }

    protected static JComponent getHeaderPanel(final Project project2, final TemplatesManager templatesManager, final String templatesTitle) {
        final JPanel panel2 = new JPanel(new BorderLayout());
        JLabel templateChooserLabel = new JLabel(templatesTitle);
        panel2.add((Component)templateChooserLabel, "West");
        final ComboBox comboBox = new ComboBox();
        templateChooserLabel.setLabelFor((Component)comboBox);
        comboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<TemplateResource>(){

            public void customize(JList list, TemplateResource value2, int index, boolean selected, boolean hasFocus) {
                this.setText(value2.getName());
            }
        });
        ComponentWithBrowseButton comboBoxWithBrowseButton = new ComponentWithBrowseButton((JComponent)comboBox, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplatesPanel ui = new TemplatesPanel(project2, templatesManager){

                    @Override
                    protected boolean onMultipleFields() {
                        return false;
                    }

                    @Override
                    @Nls
                    public String getDisplayName() {
                        return StringUtil.capitalizeWords((String)UIUtil.removeMnemonic((String)StringUtil.trimEnd((String)templatesTitle, (String)":")), (boolean)true);
                    }
                };
                ui.setHint("Visibility is applied according to File | Settings | Editor | Code Style | Java | Code Generation");
                ui.selectNodeInTree(templatesManager.getDefaultTemplate());
                if (ShowSettingsUtil.getInstance().editConfigurable((Component)panel2, (Configurable)ui)) {
                    GenerateGetterSetterHandlerBase.setComboboxModel(templatesManager, comboBox);
                }
            }
        });
        GenerateGetterSetterHandlerBase.setComboboxModel(templatesManager, comboBox);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent M) {
                templatesManager.setDefaultTemplate((TemplateResource)comboBox.getSelectedItem());
            }
        });
        panel2.add((Component)comboBoxWithBrowseButton, "Center");
        return panel2;
    }

    private static void setComboboxModel(TemplatesManager templatesManager, ComboBox comboBox) {
        Collection<TemplateResource> templates = templatesManager.getAllTemplates();
        comboBox.setModel(new DefaultComboBoxModel<TemplateResource>(templates.toArray(new TemplateResource[templates.size()])));
        comboBox.setSelectedItem((Object)templatesManager.getDefaultTemplate());
    }

    @Override
    protected abstract String getNothingFoundMessage();

    protected abstract String getNothingAcceptedMessage();

    public boolean canBeAppliedTo(PsiClass targetClass) {
        ClassMember[] allMembers = this.getAllOriginalMembers(targetClass);
        return allMembers != null && allMembers.length != 0;
    }

    @Override
    @Nullable
    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        List<EncapsulatableClassMember> list = GenerateAccessorProviderRegistrar.getEncapsulatableClassMembers(aClass);
        if (list.isEmpty()) {
            return null;
        }
        List members = ContainerUtil.findAll(list, member -> {
            try {
                return this.generateMemberPrototypes(aClass, (ClassMember)member).length > 0;
            }
            catch (GenerateCodeException e) {
                return true;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return false;
            }
        });
        return members.toArray(new ClassMember[members.size()]);
    }

    static {
        GenerateAccessorProviderRegistrar.registerProvider((NotNullFunction<PsiClass, Collection<EncapsulatableClassMember>>)((NotNullFunction)s -> {
            if (s.getLanguage() != StdLanguages.JAVA) {
                return Collections.emptyList();
            }
            ArrayList<PsiFieldMember> result2 = new ArrayList<PsiFieldMember>();
            for (PsiField field : s.getFields()) {
                if (field instanceof PsiEnumConstant) continue;
                result2.add(new PsiFieldMember(field));
            }
            return result2;
        }));
    }
}

