/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GetterTemplatesManager;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.OverrideImplementsAnnotationsHandler;
import com.intellij.codeInsight.generation.SetterTemplatesManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.light.LightTypeElement;
import com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.GenerationUtil;
import org.jetbrains.java.generate.exception.GenerateCodeException;
import org.jetbrains.java.generate.template.TemplatesManager;

public class GenerateMembersUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateMembersUtil");

    private GenerateMembersUtil() {
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersAtOffset(PsiFile file2, int offset, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        return GenerateMembersUtil.insertMembersAtOffset(file2, offset, memberPrototypes, (Function<PsiElement, PsiClass>)((Function)leaf -> GenerateMembersUtil.findClassAtOffset(file2, leaf)));
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersAtOffset(@NotNull PsiClass psiClass, int offset, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        return GenerateMembersUtil.insertMembersAtOffset(psiClass.getContainingFile(), offset, memberPrototypes, (Function<PsiElement, PsiClass>)((Function)leaf -> psiClass));
    }

    @NotNull
    private static <T extends GenerationInfo> List<T> insertMembersAtOffset(PsiFile file2, int offset, @NotNull List<T> memberPrototypes, Function<PsiElement, PsiClass> aClassFunction) throws IncorrectOperationException {
        PsiField field;
        PsiTypeElement typeElement;
        PsiElement element;
        if (memberPrototypes.isEmpty()) {
            return memberPrototypes;
        }
        PsiElement leaf = file2.findElementAt(offset);
        if (leaf == null) {
            return Collections.emptyList();
        }
        PsiClass aClass = (PsiClass)aClassFunction.fun((Object)leaf);
        if (aClass == null) {
            return Collections.emptyList();
        }
        PsiElement anchor = ((GenerationInfo)memberPrototypes.get(0)).findInsertionAnchor(aClass, leaf);
        if (anchor instanceof PsiWhiteSpace) {
            ASTNode spaceNode = anchor.getNode();
            anchor = anchor.getNextSibling();
            assert (spaceNode != null);
            if (spaceNode.getStartOffset() <= offset && spaceNode.getStartOffset() + spaceNode.getTextLength() >= offset) {
                PsiParserFacade parserFacade;
                ASTNode singleNewLineWhitespace;
                String whiteSpace = spaceNode.getText().substring(0, offset - spaceNode.getStartOffset());
                if (!StringUtil.containsLineBreak((CharSequence)whiteSpace)) {
                    whiteSpace = whiteSpace + "\n";
                }
                if ((singleNewLineWhitespace = (parserFacade = PsiParserFacade.SERVICE.getInstance((Project)file2.getProject())).createWhiteSpaceFromText(whiteSpace).getNode()) != null) {
                    spaceNode.getTreeParent().replaceChild(spaceNode, singleNewLineWhitespace);
                }
            }
        }
        for (element = anchor; !(element == null || element instanceof PsiField || element instanceof PsiMethod || element instanceof PsiClassInitializer); element = element.getNextSibling()) {
        }
        if (element instanceof PsiField && (typeElement = (field = (PsiField)element).getTypeElement()) != null && !field.equals(typeElement.getParent())) {
            field.normalizeDeclaration();
            anchor = field;
        }
        return GenerateMembersUtil.insertMembersBeforeAnchor(aClass, anchor, memberPrototypes);
    }

    @NotNull
    public static <T extends GenerationInfo> List<T> insertMembersBeforeAnchor(PsiClass aClass, @Nullable PsiElement anchor, @NotNull List<T> memberPrototypes) throws IncorrectOperationException {
        boolean before = true;
        for (GenerationInfo memberPrototype : memberPrototypes) {
            memberPrototype.insert(aClass, anchor, before);
            before = false;
            anchor = memberPrototype.getPsiMember();
        }
        return memberPrototypes;
    }

    public static void positionCaret(@NotNull Editor editor, @NotNull PsiElement firstMember, boolean toEditMethodBody) {
        int offset;
        PsiMethod method2;
        PsiCodeBlock body2;
        LOG.assertTrue(firstMember.isValid());
        Project project2 = firstMember.getProject();
        if (toEditMethodBody && (body2 = (method2 = (PsiMethod)firstMember).getBody()) != null) {
            CharSequence chars;
            PsiElement lastBodyElement;
            PsiElement firstBodyElement;
            PsiElement l = firstBodyElement = body2.getFirstBodyElement();
            while (l instanceof PsiWhiteSpace) {
                l = l.getNextSibling();
            }
            if (l == null) {
                l = body2;
            }
            PsiElement r = lastBodyElement = body2.getLastBodyElement();
            while (r instanceof PsiWhiteSpace) {
                r = r.getPrevSibling();
            }
            if (r == null) {
                r = body2;
            }
            int start = l.getTextRange().getStartOffset();
            int end = r.getTextRange().getEndOffset();
            boolean adjustLineIndent = false;
            if (start > end && firstBodyElement == lastBodyElement && firstBodyElement instanceof PsiWhiteSpaceImpl && (chars = ((PsiWhiteSpaceImpl)firstBodyElement).getChars()).length() > 1 && chars.charAt(0) == '\n' && chars.charAt(1) == '\n') {
                start = end = firstBodyElement.getTextRange().getStartOffset() + 1;
                adjustLineIndent = true;
            }
            editor.getCaretModel().moveToOffset(Math.min(start, end));
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            if (start < end) {
                editor.getSelectionModel().setSelection(start, end);
            } else if (adjustLineIndent) {
                Document document = editor.getDocument();
                RangeMarker marker = document.createRangeMarker(start, start);
                PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document);
                if (marker.isValid()) {
                    CodeStyleManager.getInstance((Project)project2).adjustLineIndent(document, marker.getStartOffset());
                }
            }
            return;
        }
        if (firstMember instanceof PsiMethod) {
            PsiMethod method3 = (PsiMethod)firstMember;
            PsiCodeBlock body3 = method3.getBody();
            if (body3 == null) {
                offset = method3.getTextRange().getStartOffset();
            } else {
                PsiJavaToken lBrace = body3.getLBrace();
                assert (lBrace != null) : firstMember.getText();
                offset = lBrace.getTextRange().getEndOffset();
            }
        } else {
            offset = firstMember.getTextRange().getStartOffset();
        }
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    public static PsiElement insert(@NotNull PsiClass aClass, @NotNull PsiMember member, @Nullable PsiElement anchor, boolean before) throws IncorrectOperationException {
        if (member instanceof PsiMethod && !aClass.isInterface()) {
            PsiParameter[] parameters2 = ((PsiMethod)member).getParameterList().getParameters();
            boolean generateFinals = CodeStyleSettingsManager.getSettings((Project)aClass.getProject()).GENERATE_FINAL_PARAMETERS;
            for (PsiParameter parameter : parameters2) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)generateFinals);
            }
        }
        if (anchor != null) {
            return before ? aClass.addBefore((PsiElement)member, anchor) : aClass.addAfter((PsiElement)member, anchor);
        }
        return aClass.add((PsiElement)member);
    }

    @Nullable
    private static PsiClass findClassAtOffset(PsiFile file2, PsiElement leaf) {
        for (PsiElement element = leaf; element != null && !(element instanceof PsiFile); element = element.getParent()) {
            if (!(element instanceof PsiClass) || element instanceof PsiTypeParameter) continue;
            PsiClass psiClass = (PsiClass)element;
            if (psiClass.isEnum()) {
                PsiElement lastChild = null;
                for (PsiElement child : psiClass.getChildren()) {
                    if (child instanceof PsiJavaToken && ";".equals(child.getText())) {
                        lastChild = child;
                        break;
                    }
                    if ((!(child instanceof PsiJavaToken) || !",".equals(child.getText())) && !(child instanceof PsiEnumConstant)) continue;
                    lastChild = child;
                }
                if (lastChild != null) {
                    int adjustedOffset = lastChild.getTextRange().getEndOffset();
                    if (leaf.getTextRange().getEndOffset() <= adjustedOffset) {
                        return GenerateMembersUtil.findClassAtOffset(file2, file2.findElementAt(adjustedOffset));
                    }
                }
            }
            return psiClass;
        }
        return null;
    }

    public static PsiMethod substituteGenericMethod(PsiMethod method2, PsiSubstitutor substitutor) {
        return GenerateMembersUtil.substituteGenericMethod(method2, substitutor, null);
    }

    public static PsiMethod substituteGenericMethod(@NotNull PsiMethod sourceMethod, @NotNull PsiSubstitutor substitutor, @Nullable PsiElement target) {
        Project project2 = sourceMethod.getProject();
        JVMElementFactory factory = GenerateMembersUtil.getFactory(sourceMethod.getProject(), target);
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        try {
            PsiMethod resultMethod = GenerateMembersUtil.createMethod(factory, sourceMethod, target);
            GenerateMembersUtil.copyModifiers(sourceMethod.getModifierList(), resultMethod.getModifierList());
            PsiSubstitutor collisionResolvedSubstitutor = GenerateMembersUtil.substituteTypeParameters(factory, target, sourceMethod.getTypeParameterList(), resultMethod.getTypeParameterList(), substitutor, sourceMethod);
            GenerateMembersUtil.substituteReturnType(PsiManager.getInstance((Project)project2), resultMethod, sourceMethod.getReturnType(), collisionResolvedSubstitutor);
            GenerateMembersUtil.substituteParameters(factory, codeStyleManager, sourceMethod.getParameterList(), resultMethod.getParameterList(), collisionResolvedSubstitutor, target);
            GenerateMembersUtil.copyDocComment(sourceMethod, resultMethod, factory);
            GlobalSearchScope scope = sourceMethod.getResolveScope();
            List<PsiClassType> thrownTypes = ExceptionUtil.collectSubstituted(collisionResolvedSubstitutor, sourceMethod.getThrowsList().getReferencedTypes(), scope);
            if (target instanceof PsiClass) {
                PsiMethod[] methods;
                for (PsiMethod psiMethod : methods = ((PsiClass)target).findMethodsBySignature(sourceMethod, true)) {
                    PsiClass aSuper;
                    if (psiMethod == null || psiMethod == sourceMethod || MethodSignatureUtil.isSuperMethod((PsiMethod)psiMethod, (PsiMethod)sourceMethod) || (aSuper = psiMethod.getContainingClass()) == null || aSuper == target) continue;
                    PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aSuper, (PsiClass)((PsiClass)target), (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    ExceptionUtil.retainExceptions(thrownTypes, ExceptionUtil.collectSubstituted(superClassSubstitutor, psiMethod.getThrowsList().getReferencedTypes(), scope));
                }
            }
            GenerateMembersUtil.substituteThrows(factory, resultMethod.getThrowsList(), collisionResolvedSubstitutor, sourceMethod, thrownTypes);
            return resultMethod;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return sourceMethod;
        }
    }

    private static void copyModifiers(@NotNull PsiModifierList sourceModifierList, @NotNull PsiModifierList targetModifierList) {
        VisibilityUtil.setVisibility((PsiModifierList)targetModifierList, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)sourceModifierList));
    }

    @NotNull
    private static PsiSubstitutor substituteTypeParameters(@NotNull JVMElementFactory factory, @Nullable PsiElement target, @Nullable PsiTypeParameterList sourceTypeParameterList, @Nullable PsiTypeParameterList targetTypeParameterList, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod) {
        if (sourceTypeParameterList == null || targetTypeParameterList == null || PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)sourceMethod, (PsiSubstitutor)substitutor)) {
            return substitutor;
        }
        HashMap substitutionMap = new HashMap(substitutor.getSubstitutionMap());
        for (PsiTypeParameter typeParam : sourceTypeParameterList.getTypeParameters()) {
            PsiTypeParameter substitutedTypeParam = GenerateMembersUtil.substituteTypeParameter(factory, typeParam, substitutor, sourceMethod);
            PsiTypeParameter resolvedTypeParam = GenerateMembersUtil.resolveTypeParametersCollision(factory, sourceTypeParameterList, target, substitutedTypeParam, substitutor);
            targetTypeParameterList.add((PsiElement)resolvedTypeParam);
            if (substitutedTypeParam == resolvedTypeParam) continue;
            substitutionMap.put(typeParam, factory.createType((PsiClass)resolvedTypeParam));
        }
        return substitutionMap.isEmpty() ? substitutor : factory.createSubstitutor((Map)substitutionMap);
    }

    @NotNull
    private static PsiTypeParameter resolveTypeParametersCollision(@NotNull JVMElementFactory factory, @NotNull PsiTypeParameterList sourceTypeParameterList, @Nullable PsiElement target, @NotNull PsiTypeParameter typeParam, @NotNull PsiSubstitutor substitutor) {
        for (PsiType type2 : substitutor.getSubstitutionMap().values()) {
            if (type2 == null || !Comparing.equal((String)type2.getCanonicalText(), (String)typeParam.getName())) continue;
            String newName = GenerateMembersUtil.suggestUniqueTypeParameterName(typeParam.getName(), sourceTypeParameterList, (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)target, PsiClass.class, (boolean)false));
            PsiTypeParameter newTypeParameter = factory.createTypeParameter(newName, typeParam.getSuperTypes());
            substitutor.put(typeParam, (PsiType)factory.createType((PsiClass)newTypeParameter));
            return newTypeParameter;
        }
        return factory.createTypeParameter(typeParam.getName(), typeParam.getSuperTypes());
    }

    @NotNull
    private static String suggestUniqueTypeParameterName(String baseName, @NotNull PsiTypeParameterList typeParameterList, @Nullable PsiClass targetClass) {
        String newName;
        int i2 = 0;
        while (!GenerateMembersUtil.checkUniqueTypeParameterName(newName = baseName + ++i2, typeParameterList) || targetClass != null && !GenerateMembersUtil.checkUniqueTypeParameterName(newName, targetClass.getTypeParameterList())) {
        }
        return newName;
    }

    private static boolean checkUniqueTypeParameterName(@NotNull String baseName, @Nullable PsiTypeParameterList typeParameterList) {
        if (typeParameterList == null) {
            return true;
        }
        for (PsiTypeParameter typeParameter : typeParameterList.getTypeParameters()) {
            if (!Comparing.equal((String)typeParameter.getName(), (String)baseName)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static PsiTypeParameter substituteTypeParameter(final @NotNull JVMElementFactory factory, @NotNull PsiTypeParameter typeParameter, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod) {
        PsiElement copy = typeParameter.copy();
        HashMap replacementMap = new HashMap();
        copy.accept((PsiElementVisitor)new JavaRecursiveElementVisitor((Map)replacementMap, substitutor, sourceMethod){
            final /* synthetic */ Map val$replacementMap;
            final /* synthetic */ PsiSubstitutor val$substitutor;
            final /* synthetic */ PsiMethod val$sourceMethod;
            {
                this.val$replacementMap = map2;
                this.val$substitutor = psiSubstitutor;
                this.val$sourceMethod = psiMethod;
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                PsiElement resolve2 = reference.resolve();
                if (resolve2 instanceof PsiTypeParameter) {
                    PsiClassType type2 = factory.createType((PsiClass)((PsiTypeParameter)resolve2));
                    this.val$replacementMap.put(reference, factory.createReferenceElementByType((PsiClassType)GenerateMembersUtil.substituteType(this.val$substitutor, (PsiType)type2, (PsiTypeParameterListOwner)this.val$sourceMethod)));
                }
            }
        });
        return (PsiTypeParameter)RefactoringUtil.replaceElementsWithMap(copy, (Map<PsiElement, PsiElement>)replacementMap);
    }

    private static void substituteParameters(@NotNull JVMElementFactory factory, @NotNull JavaCodeStyleManager codeStyleManager, @NotNull PsiParameterList sourceParameterList, @NotNull PsiParameterList targetParameterList, @NotNull PsiSubstitutor substitutor, PsiElement target) {
        PsiParameter[] parameters2 = sourceParameterList.getParameters();
        PsiParameter[] newParameters = GenerateMembersUtil.overriddenParameters(parameters2, factory, codeStyleManager, substitutor, target);
        for (int i2 = 0; i2 < newParameters.length; ++i2) {
            PsiParameter newParameter = newParameters[i2];
            GenerateMembersUtil.copyOrReplaceModifierList((PsiModifierListOwner)parameters2[i2], target, (PsiModifierListOwner)newParameter);
            targetParameterList.add((PsiElement)newParameter);
        }
    }

    public static PsiParameter[] overriddenParameters(PsiParameter[] parameters2, @NotNull JVMElementFactory factory, @NotNull JavaCodeStyleManager codeStyleManager, @NotNull PsiSubstitutor substitutor, PsiElement target) {
        PsiParameter[] result2 = new PsiParameter[parameters2.length];
        UniqueNameGenerator generator = new UniqueNameGenerator();
        for (int i2 = 0; i2 < parameters2.length; ++i2) {
            PsiParameter parameter = parameters2[i2];
            PsiType parameterType = parameter.getType();
            PsiType substituted = GenerateMembersUtil.substituteType(substitutor, parameterType, (PsiTypeParameterListOwner)((PsiMethod)parameter.getDeclarationScope()));
            String paramName = parameter.getName();
            boolean isBaseNameGenerated = true;
            boolean isSubstituted = substituted.equals(parameterType);
            if (!isSubstituted && GenerateMembersUtil.isBaseNameGenerated(codeStyleManager, TypeConversionUtil.erasure((PsiType)parameterType), paramName)) {
                isBaseNameGenerated = false;
            }
            if (paramName == null || isBaseNameGenerated && !isSubstituted && GenerateMembersUtil.isBaseNameGenerated(codeStyleManager, parameterType, paramName) || !factory.isValidParameterName(paramName)) {
                String[] names = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)substituted).names;
                paramName = names.length > 0 ? generator.generateUniqueName(names[0]) : generator.generateUniqueName("p");
            } else if (!generator.value(paramName)) {
                paramName = generator.generateUniqueName(paramName);
            }
            generator.addExistingName(paramName);
            result2[i2] = factory.createParameter(paramName, GenericsUtil.getVariableTypeByExpressionType((PsiType)substituted), target);
        }
        return result2;
    }

    private static void substituteThrows(@NotNull JVMElementFactory factory, @NotNull PsiReferenceList targetThrowsList, @NotNull PsiSubstitutor substitutor, @NotNull PsiMethod sourceMethod, List<PsiClassType> thrownTypes) {
        for (PsiClassType thrownType : thrownTypes) {
            targetThrowsList.add(factory.createReferenceElementByType((PsiClassType)GenerateMembersUtil.substituteType(substitutor, (PsiType)thrownType, (PsiTypeParameterListOwner)sourceMethod)));
        }
    }

    private static void copyDocComment(PsiMethod source, PsiMethod target, JVMElementFactory factory) {
        PsiDocComment docComment;
        PsiElement navigationElement = source.getNavigationElement();
        if (navigationElement instanceof PsiDocCommentOwner && (docComment = ((PsiDocCommentOwner)navigationElement).getDocComment()) != null) {
            target.addAfter((PsiElement)factory.createDocCommentFromText(docComment.getText()), null);
        }
        PsiParameter[] sourceParameters = source.getParameterList().getParameters();
        PsiParameterList targetParameterList = target.getParameterList();
        RefactoringUtil.fixJavadocsForParams(target, new HashSet<PsiParameter>(Arrays.asList(targetParameterList.getParameters())), (Condition<Pair<PsiParameter, String>>)((Condition)pair -> {
            int parameterIndex = targetParameterList.getParameterIndex((PsiParameter)pair.first);
            if (parameterIndex >= 0 && parameterIndex < sourceParameters.length) {
                return Comparing.strEqual((String)((String)pair.second), (String)sourceParameters[parameterIndex].getName());
            }
            return false;
        }));
    }

    @NotNull
    private static PsiMethod createMethod(@NotNull JVMElementFactory factory, @NotNull PsiMethod method2, PsiElement target) {
        if (method2.isConstructor()) {
            return factory.createConstructor(method2.getName(), target);
        }
        return factory.createMethod(method2.getName(), (PsiType)PsiType.VOID, target);
    }

    private static void substituteReturnType(@NotNull PsiManager manager, @NotNull PsiMethod method2, @Nullable PsiType returnType, @NotNull PsiSubstitutor substitutor) {
        PsiTypeElement returnTypeElement = method2.getReturnTypeElement();
        if (returnTypeElement == null || returnType == null) {
            return;
        }
        PsiType substitutedReturnType = GenerateMembersUtil.substituteType(substitutor, returnType, (PsiTypeParameterListOwner)method2);
        returnTypeElement.replace((PsiElement)new LightTypeElement(manager, substitutedReturnType instanceof PsiWildcardType ? TypeConversionUtil.erasure((PsiType)substitutedReturnType) : substitutedReturnType));
    }

    @NotNull
    private static JVMElementFactory getFactory(@NotNull Project p, @Nullable PsiElement target) {
        return target == null ? JavaPsiFacade.getInstance((Project)p).getElementFactory() : JVMElementFactories.requireFactory((Language)target.getLanguage(), (Project)p);
    }

    private static boolean isBaseNameGenerated(JavaCodeStyleManager csManager, PsiType parameterType, String paramName) {
        if (Arrays.asList(csManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)parameterType).names).contains(paramName)) {
            return true;
        }
        String typeName = JavaCodeStyleManagerImpl.getTypeName(parameterType);
        return typeName != null && NameUtil.getSuggestionsByName((String)typeName, (String)"", (String)"", (boolean)false, (boolean)false, (boolean)(parameterType instanceof PsiArrayType)).contains(paramName);
    }

    private static PsiType substituteType(PsiSubstitutor substitutor, PsiType type2, @NotNull PsiTypeParameterListOwner owner) {
        PsiType deepComponentType;
        if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)owner, (PsiSubstitutor)substitutor)) {
            return TypeConversionUtil.erasure((PsiType)type2);
        }
        PsiType psiType = substitutor.substitute(type2);
        if (psiType != null && !((deepComponentType = psiType.getDeepComponentType()) instanceof PsiCapturedWildcardType) && !(deepComponentType instanceof PsiWildcardType)) {
            return psiType;
        }
        return TypeConversionUtil.erasure((PsiType)type2);
    }

    public static boolean isChildInRange(PsiElement child, PsiElement first, PsiElement last) {
        if (child.equals(first)) {
            return true;
        }
        do {
            if (child.equals(first)) {
                return false;
            }
            if (!child.equals(last)) continue;
            return true;
        } while ((child = child.getNextSibling()) != null);
        return false;
    }

    public static void setupGeneratedMethod(PsiMethod method2) {
        PsiClass containingClass = method2.getContainingClass();
        PsiClass base = containingClass == null ? null : containingClass.getSuperClass();
        PsiMethod overridden = base == null ? null : base.findMethodBySignature(method2, true);
        boolean emptyTemplate = true;
        PsiCodeBlock body2 = method2.getBody();
        if (body2 != null) {
            PsiJavaToken lBrace = body2.getLBrace();
            int left = lBrace != null ? lBrace.getStartOffsetInParent() + 1 : 0;
            PsiJavaToken rBrace = body2.getRBrace();
            int right = rBrace != null ? rBrace.getStartOffsetInParent() : body2.getTextLength();
            emptyTemplate = StringUtil.isEmptyOrSpaces((String)body2.getText().substring(left, right));
        }
        if (overridden == null) {
            if (emptyTemplate) {
                CreateFromUsageUtils.setupMethodBody(method2, containingClass);
            }
            return;
        }
        if (emptyTemplate) {
            OverrideImplementUtil.setupMethodBody(method2, overridden, containingClass);
        }
        OverrideImplementUtil.annotateOnOverrideImplement(method2, base, overridden);
    }

    @Deprecated
    public static void copyOrReplaceModifierList(@NotNull PsiModifierListOwner sourceParam, @NotNull PsiModifierListOwner targetParam) {
        GenerateMembersUtil.copyOrReplaceModifierList(sourceParam, null, targetParam);
    }

    public static void copyOrReplaceModifierList(@NotNull PsiModifierListOwner sourceParam, @Nullable PsiElement targetClass, @NotNull PsiModifierListOwner targetParam) {
        PsiModifierList sourceModifierList = sourceParam.getModifierList();
        PsiModifierList targetModifierList = targetParam.getModifierList();
        if (sourceModifierList != null && targetModifierList != null) {
            for (String m : PsiModifier.MODIFIERS) {
                targetModifierList.setModifierProperty(m, sourceParam.hasModifierProperty(m));
            }
            OverrideImplementsAnnotationsHandler.repeatAnnotationsFromSource(sourceParam, targetClass, targetParam);
        }
    }

    public static void copyAnnotations(@NotNull PsiModifierList source, @NotNull PsiModifierList target, String ... skipAnnotations) {
        for (PsiAnnotation annotation : source.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (qualifiedName == null || ArrayUtil.contains((String)qualifiedName, (String[])skipAnnotations) || target.findAnnotation(qualifiedName) != null) continue;
            target.add((PsiElement)annotation);
        }
    }

    public static PsiMethod generateSimpleGetterPrototype(@NotNull PsiField field) {
        return GenerateMembersUtil.generatePrototype(field, PropertyUtil.generateGetterPrototype((PsiField)field));
    }

    public static PsiMethod generateSimpleSetterPrototype(@NotNull PsiField field) {
        return GenerateMembersUtil.generatePrototype(field, PropertyUtil.generateSetterPrototype((PsiField)field));
    }

    public static PsiMethod generateSimpleSetterPrototype(PsiField field, PsiClass targetClass) {
        return GenerateMembersUtil.generatePrototype(field, PropertyUtil.generateSetterPrototype((PsiField)field, (PsiClass)targetClass));
    }

    public static String suggestGetterName(PsiField field) {
        PsiMethod prototype = GenerateMembersUtil.generateGetterPrototype(field);
        return prototype != null ? prototype.getName() : PropertyUtil.suggestGetterName((PsiField)field);
    }

    public static String suggestGetterName(String name, PsiType type2, Project project2) {
        return GenerateMembersUtil.suggestGetterName(JavaPsiFacade.getElementFactory((Project)project2).createField(name, type2 instanceof PsiEllipsisType ? ((PsiEllipsisType)type2).toArrayType() : type2));
    }

    public static String suggestSetterName(PsiField field) {
        PsiMethod prototype = GenerateMembersUtil.generateSetterPrototype(field);
        return prototype != null ? prototype.getName() : PropertyUtil.suggestSetterName((PsiField)field);
    }

    public static String suggestSetterName(String name, PsiType type2, Project project2) {
        return GenerateMembersUtil.suggestSetterName(JavaPsiFacade.getElementFactory((Project)project2).createField(name, type2 instanceof PsiEllipsisType ? ((PsiEllipsisType)type2).toArrayType() : type2));
    }

    public static PsiMethod generateGetterPrototype(@NotNull PsiField field) {
        return GenerateMembersUtil.generateGetterPrototype(field, true);
    }

    public static PsiMethod generateSetterPrototype(@NotNull PsiField field) {
        return GenerateMembersUtil.generateSetterPrototype(field, true);
    }

    public static PsiMethod generateSetterPrototype(@NotNull PsiField field, PsiClass aClass) {
        return GenerateMembersUtil.generatePrototype(field, aClass, true, SetterTemplatesManager.getInstance());
    }

    static PsiMethod generateGetterPrototype(@NotNull PsiField field, boolean ignoreInvalidTemplate) {
        return GenerateMembersUtil.generatePrototype(field, field.getContainingClass(), ignoreInvalidTemplate, GetterTemplatesManager.getInstance());
    }

    static PsiMethod generateSetterPrototype(@NotNull PsiField field, boolean ignoreInvalidTemplate) {
        return GenerateMembersUtil.generatePrototype(field, field.getContainingClass(), ignoreInvalidTemplate, SetterTemplatesManager.getInstance());
    }

    private static PsiMethod generatePrototype(@NotNull PsiField field, PsiClass psiClass, boolean ignoreInvalidTemplate, TemplatesManager templatesManager) {
        PsiMethod annotationTarget;
        PsiMethod result2;
        Project project2 = field.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        String template = templatesManager.getDefaultTemplate().getTemplate();
        String methodText = GenerationUtil.velocityGenerateCode(psiClass, Collections.singletonList(field), (Map<String, String>)new HashMap(), template, 0, false);
        boolean isGetter = templatesManager instanceof GetterTemplatesManager;
        try {
            result2 = factory.createMethodFromText(methodText, (PsiElement)psiClass);
        }
        catch (IncorrectOperationException e) {
            if (ignoreInvalidTemplate) {
                LOG.info((Throwable)e);
                PsiMethod psiMethod = result2 = isGetter ? PropertyUtil.generateGetterPrototype((PsiField)field) : PropertyUtil.generateSetterPrototype((PsiField)field);
                assert (result2 != null) : field.getText();
            }
            throw new GenerateCodeException(e);
        }
        result2 = (PsiMethod)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)result2);
        if (isGetter) {
            annotationTarget = result2;
        } else {
            PsiParameter[] parameters2 = result2.getParameterList().getParameters();
            PsiParameter psiParameter = annotationTarget = parameters2.length == 1 ? parameters2[0] : null;
        }
        if (annotationTarget != null) {
            NullableNotNullManager.getInstance((Project)project2).copyNullableOrNotNullAnnotation((PsiModifierListOwner)field, (PsiModifierListOwner)annotationTarget);
        }
        return GenerateMembersUtil.generatePrototype(field, result2);
    }

    @Nullable
    private static PsiMethod generatePrototype(@NotNull PsiField field, PsiMethod result2) {
        return GenerateMembersUtil.setVisibility((PsiMember)field, GenerateMembersUtil.annotateOnOverrideImplement(field.getContainingClass(), result2));
    }

    @Contract(value="_, null -> null")
    public static PsiMethod setVisibility(PsiMember member, PsiMethod prototype) {
        String newVisibility;
        if (prototype == null) {
            return null;
        }
        String visibility = CodeStyleSettingsManager.getSettings((Project)member.getProject()).VISIBILITY;
        if ("EscalateVisible".equals(visibility)) {
            PsiClass aClass = member instanceof PsiClass ? (PsiClass)member : member.getContainingClass();
            newVisibility = PsiUtil.getMaximumModifierForMember((PsiClass)aClass, (boolean)false);
        } else {
            newVisibility = visibility;
        }
        VisibilityUtil.setVisibility((PsiModifierList)prototype.getModifierList(), (String)newVisibility);
        return prototype;
    }

    @Nullable
    public static PsiMethod annotateOnOverrideImplement(@Nullable PsiClass targetClass, @Nullable PsiMethod generated) {
        PsiMethod superMethod;
        if (generated == null || targetClass == null) {
            return generated;
        }
        if (CodeStyleSettingsManager.getSettings((Project)targetClass.getProject()).INSERT_OVERRIDE_ANNOTATION && (superMethod = targetClass.findMethodBySignature(generated, true)) != null && superMethod.getContainingClass() != targetClass) {
            OverrideImplementUtil.annotateOnOverrideImplement(generated, targetClass, superMethod, true);
        }
        return generated;
    }
}

