/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenerationInfoBase
implements GenerationInfo {
    public abstract void insert(@NotNull PsiClass var1, PsiElement var2, boolean var3) throws IncorrectOperationException;

    @NotNull
    public abstract PsiMember getPsiMember();

    @Nullable
    public PsiElement findInsertionAnchor(@NotNull PsiClass aClass, @NotNull PsiElement leaf) {
        PsiElement element = leaf;
        while (element.getParent() != aClass) {
            element = element.getParent();
        }
        PsiElement lBrace = aClass.getLBrace();
        if (lBrace == null) {
            return null;
        }
        PsiElement rBrace = aClass.getRBrace();
        if (!GenerateMembersUtil.isChildInRange(element, lBrace.getNextSibling(), rBrace)) {
            return null;
        }
        PsiElement prev = leaf.getPrevSibling();
        if (prev != null && prev.getNode() != null && prev.getNode().getElementType() == JavaTokenType.END_OF_LINE_COMMENT) {
            element = leaf.getNextSibling();
        }
        return element;
    }

    public void positionCaret(@NotNull Editor editor, boolean toEditMethodBody) {
        GenerateMembersUtil.positionCaret(editor, (PsiElement)this.getPsiMember(), toEditMethodBody);
    }
}

