/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.highlighting.BraceHighlighter;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BraceHighlightingHandler {
    private static final Key<List<RangeHighlighter>> BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY = Key.create((String)"BraceHighlighter.BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY");
    private static final Key<RangeHighlighter> LINE_MARKER_IN_EDITOR_KEY = Key.create((String)"BraceHighlighter.LINE_MARKER_IN_EDITOR_KEY");
    private static final Key<LightweightHint> HINT_IN_EDITOR_KEY = Key.create((String)"BraceHighlighter.HINT_IN_EDITOR_KEY");
    private static final Set<Editor> PROCESSED_EDITORS = Collections.newSetFromMap(new WeakHashMap());
    @NotNull
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    private final Alarm myAlarm;
    private final DocumentEx myDocument;
    private final PsiFile myPsiFile;
    private final CodeInsightSettings myCodeInsightSettings;

    private BraceHighlightingHandler(@NotNull Project project2, @NotNull Editor editor, @NotNull Alarm alarm, PsiFile psiFile) {
        this.myProject = project2;
        this.myEditor = editor;
        this.myAlarm = alarm;
        this.myDocument = (DocumentEx)this.myEditor.getDocument();
        this.myPsiFile = psiFile;
        this.myCodeInsightSettings = CodeInsightSettings.getInstance();
    }

    static void lookForInjectedAndMatchBracesInOtherThread(final @NotNull Editor editor, final @NotNull Alarm alarm, final @NotNull Processor<BraceHighlightingHandler> processor2) {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread();
        if (!BraceHighlightingHandler.isValidEditor(editor)) {
            return;
        }
        if (!PROCESSED_EDITORS.add(editor)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset();
        final Project project2 = editor.getProject();
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2);
        if (!BraceHighlightingHandler.isValidFile(psiFile)) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!ApplicationManagerEx.getApplicationEx().tryRunReadAction(() -> {
                PsiFile injected;
                try {
                    injected = psiFile instanceof PsiBinaryFile || !BraceHighlightingHandler.isValidEditor(editor) || !BraceHighlightingHandler.isValidFile(psiFile) ? null : BraceHighlightingHandler.getInjectedFileIfAny(editor, project2, offset, psiFile, alarm);
                }
                catch (RuntimeException e) {
                    ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                        public void run() {
                            PROCESSED_EDITORS.remove(editor);
                        }
                    });
                    throw e;
                }
                ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                    public void run() {
                        try {
                            if (BraceHighlightingHandler.isValidEditor(editor) && BraceHighlightingHandler.isValidFile(injected)) {
                                Editor newEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, injected);
                                BraceHighlightingHandler handler2 = new BraceHighlightingHandler(project2, newEditor, alarm, injected);
                                processor2.process((Object)handler2);
                            }
                        }
                        finally {
                            PROCESSED_EDITORS.remove(editor);
                        }
                    }
                }, ModalityState.stateForComponent((Component)editor.getComponent()));
            })) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    PROCESSED_EDITORS.remove(editor);
                    BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, alarm, processor2);
                }, ModalityState.stateForComponent((Component)editor.getComponent()));
            }
        });
    }

    private static boolean isValidFile(PsiFile file2) {
        return file2 != null && file2.isValid() && !file2.getProject().isDisposed();
    }

    private static boolean isValidEditor(@NotNull Editor editor) {
        Project editorProject = editor.getProject();
        return editorProject != null && !editorProject.isDisposed() && !editor.isDisposed() && editor.getComponent().isShowing() && !editor.isViewer();
    }

    @NotNull
    private static PsiFile getInjectedFileIfAny(@NotNull Editor editor, @NotNull Project project2, int offset, @NotNull PsiFile psiFile, @NotNull Alarm alarm) {
        Document document = editor.getDocument();
        if (PsiDocumentManager.getInstance((Project)project2).isCommitted(document)) {
            PsiFile injected;
            PsiElement injectedElement = InjectedLanguageUtil.findInjectedElementNoCommit(psiFile, offset);
            if (injectedElement != null && (injected = injectedElement.getContainingFile()) != null) {
                return injected;
            }
        } else {
            PsiDocumentManager.getInstance((Project)project2).performForCommittedDocument(document, () -> {
                if (!project2.isDisposed() && !editor.isDisposed()) {
                    BraceHighlighter.updateBraces(editor, alarm);
                }
            });
        }
        return psiFile;
    }

    @NotNull
    static EditorHighlighter getLazyParsableHighlighterIfAny(Project project2, Editor editor, PsiFile psiFile) {
        if (!PsiDocumentManager.getInstance((Project)project2).isCommitted(editor.getDocument())) {
            return ((EditorEx)editor).getHighlighter();
        }
        PsiElement elementAt = psiFile.findElementAt(editor.getCaretModel().getOffset());
        for (PsiElement e : SyntaxTraverser.psiApi().parents((Object)elementAt).takeWhile(Conditions.notEqualTo((Object)psiFile))) {
            Language language;
            if (!(PsiUtilCore.getElementType((PsiElement)e) instanceof ILazyParseableElementType) || (language = (Language)ILazyParseableElementType.LANGUAGE_KEY.get((UserDataHolder)e.getNode())) == null) continue;
            TextRange range = e.getTextRange();
            final int offset = range.getStartOffset();
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project2, (VirtualFile)psiFile.getVirtualFile());
            LexerEditorHighlighter highlighter = new LexerEditorHighlighter(syntaxHighlighter, editor.getColorsScheme()){

                @Override
                @NotNull
                public HighlighterIterator createIterator(int startOffset) {
                    return new HighlighterIteratorWrapper(super.createIterator(Math.max(startOffset - offset, 0))){

                        @Override
                        public int getStart() {
                            return super.getStart() + offset;
                        }

                        @Override
                        public int getEnd() {
                            return super.getEnd() + offset;
                        }
                    };
                }
            };
            highlighter.setText(editor.getDocument().getText(range));
            return highlighter;
        }
        return ((EditorEx)editor).getHighlighter();
    }

    void updateBraces() {
        HighlighterIterator it;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPsiFile == null || !this.myPsiFile.isValid()) {
            return;
        }
        this.clearBraceHighlighters();
        if (!this.myCodeInsightSettings.HIGHLIGHT_BRACES) {
            return;
        }
        if (this.myEditor.getSelectionModel().hasSelection()) {
            return;
        }
        if (this.myEditor.getSoftWrapModel().isInsideOrBeforeSoftWrap(this.myEditor.getCaretModel().getVisualPosition())) {
            return;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        CharSequence chars = this.myEditor.getDocument().getCharsSequence();
        int originalOffset = offset;
        EditorHighlighter highlighter = this.getEditorHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(offset);
        FileType fileType = PsiUtilBase.getPsiFileAtOffset((PsiFile)this.myPsiFile, (int)offset).getFileType();
        if (iterator.atEnd()) {
            --offset;
        } else if (BraceMatchingUtil.isRBraceToken(iterator, chars, fileType)) {
            --offset;
        } else if (!BraceMatchingUtil.isLBraceToken(iterator, chars, fileType) && --offset >= 0 && !BraceMatchingUtil.isRBraceToken(it = highlighter.createIterator(offset), chars, this.getFileTypeByIterator(it))) {
            ++offset;
        }
        if (offset < 0) {
            this.removeLineMarkers();
            return;
        }
        iterator = highlighter.createIterator(offset);
        fileType = this.getFileTypeByIterator(iterator);
        this.myAlarm.cancelAllRequests();
        if (BraceMatchingUtil.isLBraceToken(iterator, chars, fileType) || BraceMatchingUtil.isRBraceToken(iterator, chars, fileType)) {
            this.doHighlight(offset, originalOffset, fileType);
        } else if (offset > 0 && offset < chars.length()) {
            int forwardOffset;
            FileType newFileType;
            int backwardNonWsOffset;
            boolean searchForward;
            char c = chars.charAt(offset);
            boolean bl = searchForward = c != '\n';
            if (offset >= originalOffset && (c == ' ' || c == '\t' || c == '\n') && (backwardNonWsOffset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)"\t ")) >= 0 && (BraceMatchingUtil.isLBraceToken(iterator = highlighter.createIterator(backwardNonWsOffset), chars, newFileType = this.getFileTypeByIterator(iterator)) || BraceMatchingUtil.isRBraceToken(iterator, chars, newFileType))) {
                offset = backwardNonWsOffset;
                searchForward = false;
                this.doHighlight(backwardNonWsOffset, originalOffset, newFileType);
            }
            if (searchForward && ((forwardOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)offset, (String)"\t ")) > offset || c == ' ' || c == '\t') && (BraceMatchingUtil.isLBraceToken(iterator = highlighter.createIterator(forwardOffset), chars, newFileType = this.getFileTypeByIterator(iterator)) || BraceMatchingUtil.isRBraceToken(iterator, chars, newFileType))) {
                offset = forwardOffset;
                this.doHighlight(forwardOffset, originalOffset, newFileType);
            }
        }
        if (!this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
            this.removeLineMarkers();
            return;
        }
        int _offset = offset;
        FileType _fileType = fileType;
        this.myAlarm.addRequest(() -> {
            if (!this.myProject.isDisposed() && !this.myEditor.isDisposed()) {
                this.highlightScope(_offset, _fileType);
            }
        }, 300);
    }

    @NotNull
    private FileType getFileTypeByIterator(@NotNull HighlighterIterator iterator) {
        return PsiUtilBase.getPsiFileAtOffset((PsiFile)this.myPsiFile, (int)iterator.getStart()).getFileType();
    }

    @NotNull
    private FileType getFileTypeByOffset(int offset) {
        return PsiUtilBase.getPsiFileAtOffset((PsiFile)this.myPsiFile, (int)offset).getFileType();
    }

    @NotNull
    private EditorHighlighter getEditorHighlighter() {
        return BraceHighlightingHandler.getLazyParsableHighlighterIfAny(this.myProject, this.myEditor, this.myPsiFile);
    }

    private void highlightScope(int offset, @NotNull FileType fileType) {
        CharSequence chars;
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(offset)) {
            return;
        }
        if (this.myEditor.getDocument().getTextLength() <= offset) {
            return;
        }
        HighlighterIterator iterator = this.getEditorHighlighter().createIterator(offset);
        if (BraceMatchingUtil.isStructuralBraceToken(fileType, iterator, chars = this.myDocument.getCharsSequence()) && (BraceMatchingUtil.isRBraceToken(iterator, chars, fileType) || BraceMatchingUtil.isLBraceToken(iterator, chars, fileType))) {
            return;
        }
        if (!BraceMatchingUtil.findStructuralLeftBrace(fileType, iterator, chars)) {
            this.removeLineMarkers();
            return;
        }
        this.highlightLeftBrace(iterator, true, fileType);
    }

    private void doHighlight(int offset, int originalOffset, @NotNull FileType fileType) {
        CharSequence chars;
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(offset)) {
            return;
        }
        HighlighterIterator iterator = this.getEditorHighlighter().createIterator(offset);
        if (BraceMatchingUtil.isLBraceToken(iterator, chars = this.myDocument.getCharsSequence(), fileType)) {
            IElementType tokenType = iterator.getTokenType();
            iterator.advance();
            if (!iterator.atEnd() && BraceMatchingUtil.isRBraceToken(iterator, chars, fileType) && BraceMatchingUtil.isPairBraces(tokenType, iterator.getTokenType(), fileType) && originalOffset == iterator.getStart()) {
                return;
            }
            iterator.retreat();
            this.highlightLeftBrace(iterator, false, fileType);
            if (offset > 0 && BraceMatchingUtil.isRBraceToken(iterator = this.getEditorHighlighter().createIterator(offset - 1), chars, fileType)) {
                this.highlightRightBrace(iterator, fileType);
            }
        } else if (BraceMatchingUtil.isRBraceToken(iterator, chars, fileType)) {
            this.highlightRightBrace(iterator, fileType);
        }
    }

    private void highlightRightBrace(@NotNull HighlighterIterator iterator, @NotNull FileType fileType) {
        TextRange brace1 = TextRange.create((int)iterator.getStart(), (int)iterator.getEnd());
        boolean matched = BraceMatchingUtil.matchBrace(this.myDocument.getCharsSequence(), fileType, iterator, false);
        TextRange brace2 = iterator.atEnd() ? null : TextRange.create((int)iterator.getStart(), (int)iterator.getEnd());
        this.highlightBraces(brace2, brace1, matched, false, fileType);
    }

    private void highlightLeftBrace(@NotNull HighlighterIterator iterator, boolean scopeHighlighting, @NotNull FileType fileType) {
        TextRange brace1Start = TextRange.create((int)iterator.getStart(), (int)iterator.getEnd());
        boolean matched = BraceMatchingUtil.matchBrace(this.myDocument.getCharsSequence(), fileType, iterator, true);
        TextRange brace2End = iterator.atEnd() ? null : TextRange.create((int)iterator.getStart(), (int)iterator.getEnd());
        this.highlightBraces(brace1Start, brace2End, matched, scopeHighlighting, fileType);
    }

    private void highlightBraces(@Nullable TextRange lBrace, @Nullable TextRange rBrace, boolean matched, boolean scopeHighlighting, @NotNull FileType fileType) {
        FileEditorManager fileEditorManager;
        TextAttributes attributes;
        if (!matched && fileType == FileTypes.PLAIN_TEXT) {
            return;
        }
        EditorColorsScheme scheme2 = this.myEditor.getColorsScheme();
        TextAttributes textAttributes = attributes = matched ? scheme2.getAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES) : scheme2.getAttributes(CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);
        if (rBrace != null && !scopeHighlighting) {
            this.highlightBrace(rBrace, matched);
        }
        if (lBrace != null && !scopeHighlighting) {
            this.highlightBrace(lBrace, matched);
        }
        if ((fileEditorManager = FileEditorManager.getInstance((Project)this.myProject)) == null || !this.myEditor.equals(fileEditorManager.getSelectedTextEditor())) {
            return;
        }
        if (lBrace != null && rBrace != null) {
            int endLine = this.myEditor.offsetToLogicalPosition((int)rBrace.getEndOffset()).line;
            int startLine = this.myEditor.offsetToLogicalPosition((int)lBrace.getStartOffset()).line;
            if (endLine - startLine > 0) {
                Runnable runnable2 = () -> {
                    if (this.myProject.isDisposed() || this.myEditor.isDisposed()) {
                        return;
                    }
                    Color color = attributes.getBackgroundColor();
                    if (color == null) {
                        return;
                    }
                    color = ColorUtil.isDark((Color)EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground()) ? ColorUtil.shift((Color)color, (double)1.5) : color.darker();
                    this.lineMarkFragment(startLine, endLine, color);
                };
                if (!scopeHighlighting) {
                    this.myAlarm.addRequest(runnable2, 300);
                } else {
                    runnable2.run();
                }
            } else {
                this.removeLineMarkers();
            }
            if (!scopeHighlighting) {
                this.showScopeHint(lBrace.getStartOffset(), lBrace.getEndOffset());
            }
        } else if (!this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
            this.removeLineMarkers();
        }
    }

    private void highlightBrace(@NotNull TextRange braceRange, boolean matched) {
        EditorColorsScheme scheme2 = this.myEditor.getColorsScheme();
        TextAttributes attributes = matched ? scheme2.getAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES) : scheme2.getAttributes(CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);
        RangeHighlighter rbraceHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(braceRange.getStartOffset(), braceRange.getEndOffset(), 6001, attributes, HighlighterTargetArea.EXACT_RANGE);
        rbraceHighlighter.setGreedyToLeft(false);
        rbraceHighlighter.setGreedyToRight(false);
        this.registerHighlighter(rbraceHighlighter);
    }

    private void registerHighlighter(@NotNull RangeHighlighter highlighter) {
        this.getHighlightersList().add(highlighter);
    }

    @NotNull
    private List<RangeHighlighter> getHighlightersList() {
        Editor editor = this.myEditor instanceof EditorWindow ? ((EditorWindow)this.myEditor).getDelegate() : this.myEditor;
        ArrayList highlighters = (ArrayList)editor.getUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY);
        if (highlighters == null) {
            highlighters = new ArrayList();
            editor.putUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY, highlighters);
        }
        return highlighters;
    }

    private void showScopeHint(int lbraceStart, int lbraceEnd) {
        LogicalPosition bracePosition = this.myEditor.offsetToLogicalPosition(lbraceStart);
        Point braceLocation = this.myEditor.logicalPositionToXY(bracePosition);
        int y = braceLocation.y;
        this.myAlarm.addRequest(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            PsiDocumentManager.getInstance((Project)this.myProject).performLaterWhenAllCommitted(() -> {
                if (!this.myEditor.getComponent().isShowing()) {
                    return;
                }
                Rectangle viewRect = this.myEditor.getScrollingModel().getVisibleArea();
                if (y < viewRect.y) {
                    int start = lbraceStart;
                    if (!(this.myPsiFile instanceof PsiPlainTextFile) && this.myPsiFile.isValid()) {
                        start = BraceMatchingUtil.getBraceMatcher(this.getFileTypeByOffset(lbraceStart), PsiUtilCore.getLanguageAtOffset((PsiFile)this.myPsiFile, (int)lbraceStart)).getCodeConstructStart(this.myPsiFile, lbraceStart);
                    }
                    TextRange range = new TextRange(start, lbraceEnd);
                    int line1 = this.myDocument.getLineNumber(range.getStartOffset());
                    int line2 = this.myDocument.getLineNumber(range.getEndOffset());
                    line1 = Math.max(line1, line2 - 5);
                    range = new TextRange(this.myDocument.getLineStartOffset(line1), range.getEndOffset());
                    LightweightHint hint = EditorFragmentComponent.showEditorFragmentHint(this.myEditor, range, true, true);
                    this.myEditor.putUserData(HINT_IN_EDITOR_KEY, (Object)hint);
                }
            });
        }, 300, ModalityState.stateForComponent((Component)this.myEditor.getComponent()));
    }

    void clearBraceHighlighters() {
        List<RangeHighlighter> highlighters = this.getHighlightersList();
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.dispose();
        }
        highlighters.clear();
        LightweightHint hint = (LightweightHint)this.myEditor.getUserData(HINT_IN_EDITOR_KEY);
        if (hint != null) {
            hint.hide();
            this.myEditor.putUserData(HINT_IN_EDITOR_KEY, null);
        }
    }

    private void lineMarkFragment(int startLine, int endLine, @NotNull Color color) {
        this.removeLineMarkers();
        if (startLine >= endLine || endLine >= this.myDocument.getLineCount()) {
            return;
        }
        int startOffset = this.myDocument.getLineStartOffset(startLine);
        int endOffset = this.myDocument.getLineStartOffset(endLine);
        RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 0, null, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)new MyLineMarkerRenderer(color));
        this.myEditor.putUserData(LINE_MARKER_IN_EDITOR_KEY, (Object)highlighter);
    }

    private void removeLineMarkers() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighter marker = (RangeHighlighter)this.myEditor.getUserData(LINE_MARKER_IN_EDITOR_KEY);
        if (marker != null && ((MarkupModelEx)this.myEditor.getMarkupModel()).containsHighlighter(marker)) {
            marker.dispose();
        }
        this.myEditor.putUserData(LINE_MARKER_IN_EDITOR_KEY, null);
    }

    private static class MyLineMarkerRenderer
    implements LineMarkerRenderer {
        private static final int DEEPNESS = 0;
        private static final int THICKNESS = 1;
        private final Color myColor;

        private MyLineMarkerRenderer(@NotNull Color color) {
            this.myColor = color;
        }

        public void paint(Editor editor, Graphics g, Rectangle r) {
            int height = r.height + editor.getLineHeight();
            g.setColor(this.myColor);
            g.fillRect(r.x, r.y, 1, height);
            g.fillRect(r.x + 1, r.y, 0, 1);
            g.fillRect(r.x + 1, r.y + height - 1, 0, 1);
        }
    }
}

