/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightManagerImpl
extends HighlightManager {
    private final Project myProject;
    private final Key<Map<RangeHighlighter, HighlightInfo>> HIGHLIGHT_INFO_MAP_KEY = Key.create((String)"HIGHLIGHT_INFO_MAP_KEY");

    public HighlightManagerImpl(Project project2) {
        this.myProject = project2;
        ActionManagerEx.getInstanceEx().addAnActionListener((AnActionListener)new MyAnActionListener(), (Disposable)this.myProject);
        DocumentAdapter documentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent event) {
                Editor[] editors;
                Document document = event.getDocument();
                for (Editor editor : editors = EditorFactory.getInstance().getEditors(document)) {
                    Map<RangeHighlighter, HighlightInfo> map2 = HighlightManagerImpl.this.getHighlightInfoMap(editor, false);
                    if (map2 == null) {
                        return;
                    }
                    ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
                    for (RangeHighlighter highlighter : map2.keySet()) {
                        HighlightInfo info = map2.get(highlighter);
                        if (!info.editor.getDocument().equals(document) || !BitUtil.isSet((int)info.flags, (int)4)) continue;
                        highlightersToRemove.add(highlighter);
                    }
                    for (RangeHighlighter highlighter : highlightersToRemove) {
                        HighlightManagerImpl.this.removeSegmentHighlighter(editor, highlighter);
                    }
                }
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)documentListener, (Disposable)this.myProject);
    }

    @Nullable
    public Map<RangeHighlighter, HighlightInfo> getHighlightInfoMap(@NotNull Editor editor, boolean toCreate) {
        if (editor instanceof EditorWindow) {
            return this.getHighlightInfoMap(((EditorWindow)editor).getDelegate(), toCreate);
        }
        Map map2 = (Map)editor.getUserData(this.HIGHLIGHT_INFO_MAP_KEY);
        if (map2 == null && toCreate) {
            map2 = (Map)((UserDataHolderEx)editor).putUserDataIfAbsent(this.HIGHLIGHT_INFO_MAP_KEY, (Object)new HashMap());
        }
        return map2;
    }

    @NotNull
    public RangeHighlighter[] getHighlighters(@NotNull Editor editor) {
        Map<RangeHighlighter, HighlightInfo> highlightersMap = this.getHighlightInfoMap(editor, false);
        if (highlightersMap == null) {
            return RangeHighlighter.EMPTY_ARRAY;
        }
        HashSet<RangeHighlighter> set2 = new HashSet<RangeHighlighter>();
        for (Map.Entry<RangeHighlighter, HighlightInfo> entry : highlightersMap.entrySet()) {
            HighlightInfo info = entry.getValue();
            if (!info.editor.equals(editor)) continue;
            set2.add(entry.getKey());
        }
        return set2.toArray(new RangeHighlighter[set2.size()]);
    }

    private RangeHighlighter addSegmentHighlighter(@NotNull Editor editor, int startOffset, int endOffset, TextAttributes attributes, @HighlightManager.HideFlags int flags) {
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
        HighlightInfo info = new HighlightInfo(editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor, flags);
        Map<RangeHighlighter, HighlightInfo> map2 = this.getHighlightInfoMap(editor, true);
        map2.put(highlighter, info);
        return highlighter;
    }

    public boolean removeSegmentHighlighter(@NotNull Editor editor, @NotNull RangeHighlighter highlighter) {
        Map<RangeHighlighter, HighlightInfo> map2 = this.getHighlightInfoMap(editor, false);
        if (map2 == null) {
            return false;
        }
        HighlightInfo info = map2.get(highlighter);
        if (info == null) {
            return false;
        }
        MarkupModel markupModel = info.editor.getMarkupModel();
        if (((MarkupModelEx)markupModel).containsHighlighter(highlighter)) {
            highlighter.dispose();
        }
        map2.remove(highlighter);
        return true;
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiReference[] occurrences, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (occurrences.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollmarkColor = HighlightManagerImpl.getScrollMarkColor(attributes);
        int oldOffset = editor.getCaretModel().getOffset();
        int horizontalScrollOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        int verticalScrollOffset = editor.getScrollingModel().getVerticalScrollOffset();
        for (PsiReference occurrence : occurrences) {
            Project project2;
            PsiElement element = occurrence.getElement();
            int startOffset = element.getTextRange().getStartOffset();
            int start = startOffset + occurrence.getRangeInElement().getStartOffset();
            int end = startOffset + occurrence.getRangeInElement().getEndOffset();
            PsiFile containingFile = element.getContainingFile();
            Editor textEditor = InjectedLanguageUtil.openEditorFor(containingFile, project2 = element.getProject());
            if (textEditor == null) continue;
            this.addOccurrenceHighlight(textEditor, start, end, attributes, flags, outHighlighters, scrollmarkColor);
        }
        editor.getCaretModel().moveToOffset(oldOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getScrollingModel().scrollHorizontally(horizontalScrollOffset);
        editor.getScrollingModel().scrollVertically(verticalScrollOffset);
    }

    public void addElementsOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiElement[] elements, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        this.addOccurrenceHighlights(editor, elements, attributes, hideByTextChange, outHighlighters);
    }

    public void addOccurrenceHighlight(@NotNull Editor editor, int start, int end, TextAttributes attributes, int flags, Collection<RangeHighlighter> outHighlighters, Color scrollmarkColor) {
        RangeHighlighter highlighter = this.addSegmentHighlighter(editor, start, end, attributes, flags);
        if (outHighlighters != null) {
            outHighlighters.add(highlighter);
        }
        if (scrollmarkColor != null) {
            highlighter.setErrorStripeMarkColor(scrollmarkColor);
        }
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, @Nullable Collection<RangeHighlighter> highlighters) {
        this.addRangeHighlight(editor, startOffset, endOffset, attributes, hideByTextChange, false, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<RangeHighlighter> highlighters) {
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        if (hideByAnyKey) {
            flags |= 2;
        }
        Color scrollmarkColor = HighlightManagerImpl.getScrollMarkColor(attributes);
        this.addOccurrenceHighlight(editor, startOffset, endOffset, attributes, flags, highlighters, scrollmarkColor);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiElement[] elements, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (elements.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollmarkColor = HighlightManagerImpl.getScrollMarkColor(attributes);
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        for (PsiElement element : elements) {
            TextRange range = element.getTextRange();
            range = InjectedLanguageManager.getInstance((Project)this.myProject).injectedToHost(element, range);
            this.addOccurrenceHighlight(editor, HighlightManagerImpl.trimOffsetToDocumentSize(editor, range.getStartOffset()), HighlightManagerImpl.trimOffsetToDocumentSize(editor, range.getEndOffset()), attributes, flags, outHighlighters, scrollmarkColor);
        }
    }

    private static int trimOffsetToDocumentSize(@NotNull Editor editor, int offset) {
        if (offset < 0) {
            return 0;
        }
        int textLength = editor.getDocument().getTextLength();
        return offset < textLength ? offset : textLength;
    }

    @Nullable
    private static Color getScrollMarkColor(@NotNull TextAttributes attributes) {
        if (attributes.getErrorStripeColor() != null) {
            return attributes.getErrorStripeColor();
        }
        if (attributes.getBackgroundColor() != null) {
            return attributes.getBackgroundColor().darker();
        }
        return null;
    }

    public boolean hideHighlights(@NotNull Editor editor, @HighlightManager.HideFlags int mask) {
        Map<RangeHighlighter, HighlightInfo> map2 = this.getHighlightInfoMap(editor, false);
        if (map2 == null) {
            return false;
        }
        boolean done2 = false;
        ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
        for (RangeHighlighter highlighter : map2.keySet()) {
            HighlightInfo info = map2.get(highlighter);
            if (!info.editor.equals(editor) || (info.flags & mask) == 0) continue;
            highlightersToRemove.add(highlighter);
            done2 = true;
        }
        for (RangeHighlighter highlighter : highlightersToRemove) {
            this.removeSegmentHighlighter(editor, highlighter);
        }
        return done2;
    }

    static class HighlightInfo {
        final Editor editor;
        @HighlightManager.HideFlags
        final int flags;

        public HighlightInfo(Editor editor, @HighlightManager.HideFlags int flags) {
            this.editor = editor;
            this.flags = flags;
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            this.requestHideHighlights(dataContext);
        }

        public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        }

        public void beforeEditorTyping(char c, DataContext dataContext) {
            this.requestHideHighlights(dataContext);
        }

        private void requestHideHighlights(DataContext dataContext) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (editor == null) {
                return;
            }
            HighlightManagerImpl.this.hideHighlights(editor, 2);
        }
    }
}

