/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.DeclarationRangeHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.MixinExtension;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarationRangeUtil {
    public static Map<Class, DeclarationRangeHandler> ourDeclarationRangeRegistry = new HashMap<Class, DeclarationRangeHandler>();

    private DeclarationRangeUtil() {
    }

    public static void setDeclarationHandler(@NotNull Class clazz, DeclarationRangeHandler handler2) {
        ourDeclarationRangeRegistry.put(clazz, handler2);
    }

    @NotNull
    public static TextRange getDeclarationRange(PsiElement container) {
        TextRange textRange = DeclarationRangeUtil.getPossibleDeclarationAtRange(container);
        assert (textRange != null) : "Declaration range is invalid for " + container.getClass();
        return textRange;
    }

    @Nullable
    public static TextRange getPossibleDeclarationAtRange(PsiElement container) {
        DeclarationRangeHandler handler2 = (DeclarationRangeHandler)MixinExtension.getInstance((ExtensionPointName)DeclarationRangeHandler.EP_NAME, (Object)container);
        if (handler2 != null) {
            return handler2.getDeclarationRange(container);
        }
        for (Class clazz : ourDeclarationRangeRegistry.keySet()) {
            DeclarationRangeHandler handler22;
            if (!clazz.isInstance(container) || (handler22 = ourDeclarationRangeRegistry.get(clazz)) == null) continue;
            return handler22.getDeclarationRange(container);
        }
        return null;
    }
}

