/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaTypeProvider
extends ExpressionTypeProvider<PsiExpression> {
    @NotNull
    public String getInformationHint(@NotNull PsiExpression element) {
        PsiType type2 = element.getType();
        String text = type2 == null ? "<unknown>" : type2.getCanonicalText();
        return StringUtil.escapeXml((String)text);
    }

    @NotNull
    public String getErrorHint() {
        return "No expression found";
    }

    @NotNull
    public List<PsiExpression> getExpressionsAt(@NotNull PsiElement elementAt) {
        return SyntaxTraverser.psiApi().parents((Object)elementAt).filter(PsiExpression.class).filter(JavaTypeProvider::isLargestNonTrivialExpression).toList();
    }

    private static boolean isLargestNonTrivialExpression(@NotNull PsiExpression e) {
        PsiElement p = e.getParent();
        if (p instanceof PsiPostfixExpression) {
            return false;
        }
        if (p instanceof PsiPrefixExpression) {
            return false;
        }
        return !(p instanceof PsiMethodCallExpression) || ((PsiMethodCallExpression)p).getMethodExpression() != e;
    }
}

