/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipLinkHandlerEP;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LineTooltipRenderer
extends ComparableObject.Impl
implements TooltipRenderer {
    @NonNls
    protected String myText;
    private boolean myActiveLink = false;
    private int myCurrentWidth;

    public LineTooltipRenderer(String text, Object[] comparable) {
        super(comparable);
        this.myText = text;
    }

    public LineTooltipRenderer(String text, int width, Object[] comparable) {
        this(text, comparable);
        this.myCurrentWidth = width;
    }

    @Override
    public LightweightHint show(final @NotNull Editor editor, final @NotNull Point p, final boolean alignToRight, final @NotNull TooltipGroup group, final @NotNull HintHint hintHint) {
        if (this.myText == null) {
            return null;
        }
        this.myText = this.myText.replaceAll(String.valueOf('\u001b'), "");
        final boolean expanded = this.myCurrentWidth > 0 && this.dressDescription(editor);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        final JComponent contentComponent = editor.getContentComponent();
        JComponent editorComponent = editor.getComponent();
        if (!editorComponent.isShowing()) {
            return null;
        }
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        final JEditorPane pane = IdeTooltipManager.initPane(new Html(this.myText).setKeepFont(true), hintHint, layeredPane);
        hintHint.setContentActive(LineTooltipRenderer.isActiveHtml(this.myText));
        if (!hintHint.isAwtTooltip()) {
            LineTooltipRenderer.correctLocation(editor, pane, p, alignToRight, expanded, this.myCurrentWidth);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)pane);
        scrollPane.setBorder(null);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setOpaque(hintHint.isOpaqueAllowed());
        scrollPane.getViewport().setOpaque(hintHint.isOpaqueAllowed());
        scrollPane.setBackground(hintHint.getTextBackground());
        scrollPane.getViewport().setBackground(hintHint.getTextBackground());
        scrollPane.setViewportBorder(null);
        if (hintHint.isRequestFocus()) {
            pane.setFocusable(true);
        }
        final Ref actionRef = new Ref();
        final LightweightHint hint = new LightweightHint(scrollPane){

            @Override
            public void hide() {
                LineTooltipRenderer.this.onHide(pane);
                super.hide();
                AnAction action = (AnAction)actionRef.get();
                if (action != null) {
                    action.unregisterCustomShortcutSet(contentComponent);
                }
            }
        };
        actionRef.set((Object)new AnAction(){
            {
                this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeymapManager.getInstance().getActiveKeymap().getShortcuts("ShowErrorDescription")), contentComponent);
            }

            public void actionPerformed(AnActionEvent e) {
                hintHint.setRequestFocus(ScreenReader.isActive() && e.getInputEvent() instanceof KeyEvent);
                LineTooltipRenderer.this.expand(hint, editor, p, pane, alignToRight, group, hintHint);
            }
        });
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                LineTooltipRenderer.this.myActiveLink = true;
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    LineTooltipRenderer.this.myActiveLink = false;
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = e.getURL();
                    if (url != null) {
                        BrowserUtil.browse((URL)url);
                        hint.hide();
                        return;
                    }
                    String description = e.getDescription();
                    if (description != null && LineTooltipRenderer.handle(description, editor)) {
                        hint.hide();
                        return;
                    }
                    if (!expanded) {
                        LineTooltipRenderer.this.expand(hint, editor, p, pane, alignToRight, group, hintHint);
                    } else {
                        LineTooltipRenderer.this.stripDescription();
                        hint.hide();
                        TooltipController.getInstance().showTooltip(editor, new Point(p.x - 3, p.y - 3), LineTooltipRenderer.this.createRenderer(LineTooltipRenderer.this.myText, 0), false, group, hintHint);
                    }
                }
            }
        });
        pane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!LineTooltipRenderer.this.myActiveLink) {
                    MouseEvent newMouseEvent = SwingUtilities.convertMouseEvent(e.getComponent(), e, contentComponent);
                    hint.hide();
                    contentComponent.dispatchEvent(newMouseEvent);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!expanded) {
                    hint.hide();
                }
            }
        });
        hintManager.showEditorHint(hint, editor, p, 58, 0, false, hintHint);
        return hint;
    }

    private static boolean handle(@NotNull String ref, @NotNull Editor editor) {
        return TooltipLinkHandlerEP.handleLink(ref, editor);
    }

    private void expand(@NotNull LightweightHint hint, @NotNull Editor editor, @NotNull Point p, @NotNull JEditorPane pane, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint hintHint) {
        hint.hide();
        if (this.myCurrentWidth > 0) {
            this.stripDescription();
        }
        TooltipController.getInstance().showTooltip(editor, new Point(p.x - 3, p.y - 3), this.createRenderer(this.myText, this.myCurrentWidth > 0 ? 0 : pane.getWidth()), alignToRight, group, hintHint);
    }

    public static void correctLocation(Editor editor, JComponent tooltipComponent, Point p, boolean alignToRight, boolean expanded, int currentWidth) {
        JComponent editorComponent = editor.getComponent();
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        int widthLimit = layeredPane.getWidth() - 10;
        int heightLimit = layeredPane.getHeight() - 5;
        Dimension dimension = LineTooltipRenderer.correctLocation(editor, p, alignToRight, expanded, tooltipComponent, layeredPane, widthLimit, heightLimit, currentWidth);
        tooltipComponent.setSize(dimension);
        tooltipComponent.setMaximumSize(dimension);
        tooltipComponent.setMinimumSize(dimension);
        tooltipComponent.setPreferredSize(dimension);
    }

    private static Dimension correctLocation(Editor editor, Point p, boolean alignToRight, boolean expanded, JComponent tooltipComponent, JLayeredPane layeredPane, int widthLimit, int heightLimit, int currentWidth) {
        Dimension preferredSize = tooltipComponent.getPreferredSize();
        int width = expanded ? 3 * currentWidth / 2 : preferredSize.width;
        int height = expanded ? Math.max(preferredSize.height, 150) : preferredSize.height;
        Dimension dimension = new Dimension(width, height);
        if (alignToRight) {
            p.x = Math.max(0, p.x - width);
        }
        p.x += 3;
        p.y += 3;
        if (p.x >= widthLimit - width) {
            p.x = widthLimit - width;
            width = Math.min(width, widthLimit);
            dimension = new Dimension(width, height += 20);
        }
        if (p.x < 3) {
            p.x = 3;
        }
        if (p.y > heightLimit - height) {
            p.y = heightLimit - height;
            height = Math.min(heightLimit, height);
            dimension = new Dimension(width, height);
        }
        if (p.y < 3) {
            p.y = 3;
        }
        LineTooltipRenderer.locateOutsideMouseCursor(editor, layeredPane, p, width, height, heightLimit);
        return dimension;
    }

    private static void locateOutsideMouseCursor(Editor editor, JComponent editorComponent, Point p, int width, int height, int heightLimit) {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return;
        }
        Point mouse = pointerInfo.getLocation();
        SwingUtilities.convertPointFromScreen(mouse, editorComponent);
        Rectangle tooltipRect = new Rectangle(p, new Dimension(width, height));
        tooltipRect.setBounds(tooltipRect.x, tooltipRect.y - editor.getLineHeight(), width, height + 2 * editor.getLineHeight());
        if (tooltipRect.contains(mouse)) {
            p.y = mouse.y + height + editor.getLineHeight() > heightLimit && mouse.y - height - editor.getLineHeight() > 0 ? mouse.y - height - editor.getLineHeight() : mouse.y + editor.getLineHeight();
        }
    }

    protected void onHide(JComponent contentComponent) {
    }

    protected LineTooltipRenderer createRenderer(String text, int width) {
        return new LineTooltipRenderer(text, width, this.getEqualityObjects());
    }

    protected boolean dressDescription(@NotNull Editor editor) {
        return false;
    }

    protected void stripDescription() {
    }

    static boolean isActiveHtml(String html) {
        return html.contains("</a>");
    }

    public void addBelow(String text) {
        String newBody;
        if (this.myText == null) {
            newBody = UIUtil.getHtmlBody((String)text);
        } else {
            String html1 = UIUtil.getHtmlBody((String)this.myText);
            String html2 = UIUtil.getHtmlBody((String)text);
            newBody = html1 + "<hr size=1 noshade>" + html2;
        }
        this.myText = XmlStringUtil.wrapInHtml((CharSequence)newBody);
    }

    public String getText() {
        return this.myText;
    }
}

