/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.google.common.collect.ImmutableMap;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUIContextEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SideBorder;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoComponent
extends JPanel {
    private final Object[] myObjects;
    private int myCurrentParameterIndex;
    private PsiElement myParameterOwner;
    private Object myHighlighted;
    @NotNull
    private final ParameterInfoHandler myHandler;
    private final OneElementComponent[] myPanels;
    private final Font NORMAL_FONT;
    private final Font BOLD_FONT;
    private static final Border LAST_ITEM_BORDER = BorderFactory.createEmptyBorder();
    private static final Border BOTTOM_BORDER = new SideBorder((Color)new JBColor((Color)JBColor.LIGHT_GRAY, (Color)Gray._90), 8);
    protected int myWidthLimit = 500;
    private static final Map<ParameterInfoUIContextEx.Flag, String> FLAG_TO_TAG = ImmutableMap.of((Object)ParameterInfoUIContextEx.Flag.HIGHLIGHT, (Object)"b", (Object)ParameterInfoUIContextEx.Flag.DISABLE, (Object)"font color=gray", (Object)ParameterInfoUIContextEx.Flag.STRIKEOUT, (Object)"strike");
    private static final Comparator<TextRange> TEXT_RANGE_COMPARATOR = (o1, o2) -> {
        if (o1.getStartOffset() == o2.getStartOffset()) {
            return o1.getEndOffset() > o2.getEndOffset() ? 1 : -1;
        }
        if (o1.getStartOffset() > o2.getStartOffset()) {
            return 1;
        }
        if (o1.getEndOffset() > o2.getEndOffset()) {
            return 1;
        }
        return -1;
    };
    private boolean myRequestFocus;

    public static ParameterInfoUIContextEx createContext(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler2, int currentParameterIndex) {
        return ParameterInfoComponent.createContext(objects, editor, handler2, currentParameterIndex, null);
    }

    public static ParameterInfoUIContextEx createContext(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler2, int currentParameterIndex, @Nullable PsiElement parameterOwner) {
        ParameterInfoComponent infoComponent = new ParameterInfoComponent(objects, editor, handler2);
        infoComponent.setCurrentParameterIndex(currentParameterIndex);
        infoComponent.setParameterOwner(parameterOwner);
        return infoComponent.new MyParameterContext();
    }

    ParameterInfoComponent(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler2) {
        this(objects, editor, handler2, false);
    }

    ParameterInfoComponent(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler2, boolean requestFocus) {
        super(new BorderLayout());
        this.myRequestFocus = requestFocus;
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JComponent editorComponent = editor.getComponent();
            JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
            this.myWidthLimit = layeredPane.getWidth();
        }
        this.NORMAL_FONT = UIUtil.getLabelFont();
        this.BOLD_FONT = this.NORMAL_FONT.deriveFont(1);
        this.myObjects = objects;
        this.setBackground(HintUtil.getInformationColor());
        this.myHandler = handler2;
        this.myPanels = new OneElementComponent[this.myObjects.length];
        JPanel panel2 = new JPanel(new GridBagLayout());
        for (int i2 = 0; i2 < this.myObjects.length; ++i2) {
            this.myPanels[i2] = new OneElementComponent();
            panel2.add((Component)this.myPanels[i2], new GridBagConstraints(0, i2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (this.myRequestFocus) {
            AccessibleContextUtil.setName((Component)this, (String)"Parameter Info. Press TAB to navigate through each element. Press ESC to close.");
        }
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)panel2);
        pane.setBorder(null);
        pane.setHorizontalScrollBarPolicy(30);
        this.add((Component)pane, "Center");
        this.myCurrentParameterIndex = -1;
    }

    @Override
    public Dimension getPreferredSize() {
        int size = this.myPanels.length;
        Dimension preferredSize = super.getPreferredSize();
        if (size >= 0 && size <= 20) {
            return preferredSize;
        }
        return new Dimension(preferredSize.width + 20, 200);
    }

    public Object getHighlighted() {
        return this.myHighlighted;
    }

    public void setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public boolean isRequestFocus() {
        return this.myRequestFocus;
    }

    public void update() {
        MyParameterContext context = new MyParameterContext();
        for (int i2 = 0; i2 < this.myObjects.length; ++i2) {
            context.i = i2;
            Object o = this.myObjects[i2];
            this.myHandler.updateUI(o, (ParameterInfoUIContext)context);
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public Object[] getObjects() {
        return this.myObjects;
    }

    void setEnabled(int index, boolean enabled) {
        this.myPanels[index].setEnabled(enabled);
    }

    boolean isEnabled(int index) {
        return this.myPanels[index].isEnabled();
    }

    public void setCurrentParameterIndex(int currentParameterIndex) {
        this.myCurrentParameterIndex = currentParameterIndex;
    }

    public int getCurrentParameterIndex() {
        return this.myCurrentParameterIndex;
    }

    public void setParameterOwner(PsiElement element) {
        this.myParameterOwner = element;
    }

    public PsiElement getParameterOwner() {
        return this.myParameterOwner;
    }

    public void setHighlightedParameter(Object element) {
        this.myHighlighted = element;
    }

    private class OneLineComponent
    extends JPanel {
        JLabel myLabel;
        private boolean isDisabledBeforeHighlight;

        private OneLineComponent() {
            super(new GridBagLayout());
            this.myLabel = new JLabel("", 2);
            this.isDisabledBeforeHighlight = false;
            this.myLabel.setOpaque(true);
            this.myLabel.setFont(ParameterInfoComponent.this.NORMAL_FONT);
            if (ParameterInfoComponent.this.myRequestFocus) {
                this.myLabel.setFocusable(true);
            }
            this.add((Component)this.myLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        private String setup(String text, boolean isDisabled, boolean isStrikeout, Color background, @Nullable TextRange range) {
            TreeMap<TextRange, ParameterInfoUIContextEx.Flag> flagsMap = new TreeMap<TextRange, ParameterInfoUIContextEx.Flag>(TEXT_RANGE_COMPARATOR);
            if (range != null) {
                flagsMap.put(range, ParameterInfoUIContextEx.Flag.HIGHLIGHT);
            }
            if (isDisabled) {
                flagsMap.put(TextRange.create((int)0, (int)text.length()), ParameterInfoUIContextEx.Flag.DISABLE);
            }
            if (isStrikeout) {
                flagsMap.put(TextRange.create((int)0, (int)text.length()), ParameterInfoUIContextEx.Flag.STRIKEOUT);
            }
            return this.setup(text, flagsMap, background);
        }

        private String setup(@NotNull String text, @NotNull Map<TextRange, ParameterInfoUIContextEx.Flag> flagsMap, @NotNull Color background) {
            this.myLabel.setBackground(background);
            this.setBackground(background);
            this.myLabel.setForeground(JBColor.foreground());
            if (flagsMap.isEmpty()) {
                this.myLabel.setText(XmlStringUtil.wrapInHtml((CharSequence)text));
            } else {
                String labelText = this.buildLabelText(text, flagsMap);
                this.myLabel.setText(labelText);
            }
            if (UIUtil.isUnderDarcula()) {
                this.myLabel.setText(this.myLabel.getText().replace("<b>", "<b color=ffC800>"));
            }
            return this.myLabel.getText();
        }

        private String buildLabelText(@NotNull String text, @NotNull Map<TextRange, ParameterInfoUIContextEx.Flag> flagsMap) {
            StringBuilder labelText = new StringBuilder(text);
            String disabledTag = (String)FLAG_TO_TAG.get(ParameterInfoUIContextEx.Flag.DISABLE);
            HashMap<Integer, Integer> faultMap = new HashMap<Integer, Integer>();
            if (this.isDisabledBeforeHighlight) {
                String tag = this.getTag(disabledTag);
                labelText.insert(0, tag);
                faultMap.put(0, tag.length());
            }
            for (Map.Entry<TextRange, ParameterInfoUIContextEx.Flag> entry : flagsMap.entrySet()) {
                TextRange highlightRange = entry.getKey();
                ParameterInfoUIContextEx.Flag flag = entry.getValue();
                String tagValue = (String)FLAG_TO_TAG.get(flag);
                String tag = this.getTag(tagValue);
                int startOffset = highlightRange.getStartOffset();
                int endOffset = highlightRange.getEndOffset() + tag.length();
                for (Map.Entry entry1 : faultMap.entrySet()) {
                    if ((Integer)entry1.getKey() < highlightRange.getStartOffset()) {
                        startOffset += ((Integer)entry1.getValue()).intValue();
                    }
                    if ((Integer)entry1.getKey() >= highlightRange.getEndOffset()) continue;
                    endOffset += ((Integer)entry1.getValue()).intValue();
                }
                if (flag == ParameterInfoUIContextEx.Flag.HIGHLIGHT && this.isDisabledBeforeHighlight) {
                    String disableCloseTag = this.getClosingTag(disabledTag);
                    labelText.insert(startOffset, disableCloseTag);
                    faultMap.put(highlightRange.getStartOffset(), disableCloseTag.length());
                }
                labelText.insert(startOffset, tag);
                faultMap.put(highlightRange.getStartOffset(), tag.length());
                String endTag = this.getClosingTag(tagValue);
                labelText.insert(endOffset, endTag);
                faultMap.put(highlightRange.getEndOffset(), endTag.length());
            }
            return XmlStringUtil.wrapInHtml((CharSequence)labelText);
        }

        private String getTag(@NotNull String tagValue) {
            return "<" + tagValue + ">";
        }

        private String getClosingTag(@NotNull String tagValue) {
            return "</" + tagValue + ">";
        }

        public void setDisabledBeforeHighlight() {
            this.isDisabledBeforeHighlight = true;
        }
    }

    private class OneElementComponent
    extends JPanel {
        private OneLineComponent[] myOneLineComponents;

        public OneElementComponent() {
            super(new GridBagLayout());
            this.myOneLineComponents = new OneLineComponent[0];
        }

        private String setup(String text, Function<String, String> escapeFunction, int highlightStartOffset, int highlightEndOffset, boolean isDisabled, boolean strikeout, boolean isDisabledBeforeHighlight, Color background) {
            StringBuilder buf = new StringBuilder();
            this.removeAll();
            String[] lines = UIUtil.splitText((String)text, (FontMetrics)this.getFontMetrics(ParameterInfoComponent.this.BOLD_FONT), (int)ParameterInfoComponent.this.myWidthLimit, (char)',');
            this.myOneLineComponents = new OneLineComponent[lines.length];
            int lineOffset = 0;
            boolean hasHighlighting = highlightStartOffset >= 0 && highlightEndOffset > highlightStartOffset;
            TextRange highlightingRange = hasHighlighting ? new TextRange(highlightStartOffset, highlightEndOffset) : null;
            for (int i2 = 0; i2 < lines.length; ++i2) {
                String line = lines[i2];
                this.myOneLineComponents[i2] = new OneLineComponent();
                TextRange lRange = new TextRange(lineOffset, lineOffset + line.length());
                TextRange hr = highlightingRange == null ? null : lRange.intersection(highlightingRange);
                hr = hr == null ? null : hr.shiftRight(-lineOffset);
                String before = this.escapeString(hr == null ? line : line.substring(0, hr.getStartOffset()), escapeFunction);
                String in = hr == null ? "" : this.escapeString(hr.substring(line), escapeFunction);
                String after2 = hr == null ? "" : this.escapeString(line.substring(hr.getEndOffset(), line.length()), escapeFunction);
                TextRange escapedHighlightingRange = in.isEmpty() ? null : TextRange.create((int)before.length(), (int)(before.length() + in.length()));
                buf.append(this.myOneLineComponents[i2].setup(before + in + after2, isDisabled, strikeout, background, escapedHighlightingRange));
                if (isDisabledBeforeHighlight && (highlightStartOffset < 0 || highlightEndOffset > lineOffset)) {
                    this.myOneLineComponents[i2].setDisabledBeforeHighlight();
                }
                this.add((Component)this.myOneLineComponents[i2], new GridBagConstraints(0, i2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                lineOffset += line.length();
            }
            return buf.toString();
        }

        private String escapeString(String line, Function<String, String> escapeFunction) {
            line = XmlStringUtil.escapeString((String)line);
            return escapeFunction == null ? line : (String)escapeFunction.fun((Object)line);
        }

        public String setup(String[] texts, Function<String, String> escapeFunction, EnumSet<ParameterInfoUIContextEx.Flag>[] flags, Color background) {
            String paramText;
            StringBuilder buf = new StringBuilder();
            this.removeAll();
            this.setBackground(background);
            int index = 0;
            int curOffset = 0;
            ArrayList<OneLineComponent> components = new ArrayList<OneLineComponent>();
            TreeMap<TextRange, ParameterInfoUIContextEx.Flag> flagsMap = new TreeMap<TextRange, ParameterInfoUIContextEx.Flag>(TEXT_RANGE_COMPARATOR);
            String line = "";
            for (int i2 = 0; i2 < texts.length && (paramText = this.escapeString(texts[i2], escapeFunction)) != null; ++i2) {
                line = line + texts[i2];
                EnumSet<ParameterInfoUIContextEx.Flag> flag = flags[i2];
                if (flag.contains(ParameterInfoUIContextEx.Flag.HIGHLIGHT)) {
                    flagsMap.put(TextRange.create((int)curOffset, (int)(curOffset + paramText.trim().length())), ParameterInfoUIContextEx.Flag.HIGHLIGHT);
                }
                if (flag.contains(ParameterInfoUIContextEx.Flag.DISABLE)) {
                    flagsMap.put(TextRange.create((int)curOffset, (int)(curOffset + paramText.trim().length())), ParameterInfoUIContextEx.Flag.DISABLE);
                }
                if (flag.contains(ParameterInfoUIContextEx.Flag.STRIKEOUT)) {
                    flagsMap.put(TextRange.create((int)curOffset, (int)(curOffset + paramText.trim().length())), ParameterInfoUIContextEx.Flag.STRIKEOUT);
                }
                curOffset += paramText.length();
                if (line.length() < 50) continue;
                OneLineComponent component = new OneLineComponent();
                buf.append(component.setup(this.escapeString(line, escapeFunction), flagsMap, background));
                this.add((Component)component, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                ++index;
                flagsMap.clear();
                curOffset = 0;
                line = "";
                components.add(component);
            }
            OneLineComponent component = new OneLineComponent();
            buf.append(component.setup(this.escapeString(line, escapeFunction), flagsMap, background));
            this.add((Component)component, new GridBagConstraints(0, index, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            components.add(component);
            this.myOneLineComponents = components.toArray(new OneLineComponent[components.size()]);
            return buf.toString();
        }
    }

    class MyParameterContext
    implements ParameterInfoUIContextEx {
        private int i;
        private Function<String, String> myEscapeFunction;

        MyParameterContext() {
        }

        public String setupUIComponentPresentation(String text, int highlightStartOffset, int highlightEndOffset, boolean isDisabled, boolean strikeout, boolean isDisabledBeforeHighlight, Color background) {
            String resultedText = ParameterInfoComponent.this.myPanels[this.i].setup(text, (Function<String, String>)this.myEscapeFunction, highlightStartOffset, highlightEndOffset, isDisabled, strikeout, isDisabledBeforeHighlight, background);
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() ? LAST_ITEM_BORDER : BOTTOM_BORDER);
            return resultedText;
        }

        public String setupUIComponentPresentation(String[] texts, EnumSet<ParameterInfoUIContextEx.Flag>[] flags, Color background) {
            String resultedText = ParameterInfoComponent.this.myPanels[this.i].setup(texts, this.myEscapeFunction, flags, background);
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() ? LAST_ITEM_BORDER : BOTTOM_BORDER);
            return resultedText;
        }

        public void setEscapeFunction(@Nullable Function<String, String> escapeFunction) {
            this.myEscapeFunction = escapeFunction;
        }

        public boolean isUIComponentEnabled() {
            return ParameterInfoComponent.this.isEnabled(this.i);
        }

        public void setUIComponentEnabled(boolean enabled) {
            ParameterInfoComponent.this.setEnabled(this.i, enabled);
        }

        public boolean isLastParameterOwner() {
            return this.i == ParameterInfoComponent.this.myPanels.length - 1;
        }

        public int getCurrentParameterIndex() {
            return ParameterInfoComponent.this.myCurrentParameterIndex;
        }

        public PsiElement getParameterOwner() {
            return ParameterInfoComponent.this.myParameterOwner;
        }

        public Color getDefaultParameterColor() {
            Color color = HintUtil.getInformationColor();
            return !ParameterInfoComponent.this.myObjects[this.i].equals(ParameterInfoComponent.this.myHighlighted) ? color : (ColorUtil.isDark((Color)color) ? ColorUtil.brighter((Color)color, (int)2) : ColorUtil.darker((Color)color, (int)2));
        }
    }
}

