/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.hint.DeclarationRangeUtil;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reference.SoftReference;
import com.intellij.ui.LightweightHint;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public class ShowContainerInfoHandler
implements CodeInsightActionHandler {
    private static final Key<WeakReference<LightweightHint>> MY_LAST_HINT_KEY = Key.create((String)"MY_LAST_HINT_KEY");
    private static final Key<PsiElement> CONTAINER_KEY = Key.create((String)"CONTAINER_KEY");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement container;
        block16: {
            StructureViewBuilder builder;
            container = null;
            WeakReference ref = (WeakReference)editor.getUserData(MY_LAST_HINT_KEY);
            LightweightHint hint = (LightweightHint)SoftReference.dereference((Reference)ref);
            if (hint != null && hint.isVisible()) {
                hint.hide();
                container = (PsiElement)hint.getUserData(CONTAINER_KEY);
                if (container != null && !container.isValid()) {
                    container = null;
                }
            }
            if ((builder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(file2)) instanceof TreeBasedStructureViewBuilder) {
                StructureViewModel model = ((TreeBasedStructureViewBuilder)builder).createStructureViewModel(editor);
                boolean goOneLevelUp = true;
                try {
                    if (container == null) {
                        goOneLevelUp = false;
                        Object element = model.getCurrentEditorElement();
                        if (element instanceof PsiElement) {
                            container = (PsiElement)element;
                        }
                    }
                }
                finally {
                    model.dispose();
                }
                block3: while (true) {
                    if (container == null || container instanceof PsiFile) {
                        return;
                    }
                    if (goOneLevelUp) {
                        goOneLevelUp = false;
                    } else if (!ShowContainerInfoHandler.isDeclarationVisible(container, editor)) break block16;
                    container = container.getParent();
                    do {
                        if (container == null || DeclarationRangeUtil.getPossibleDeclarationAtRange(container) != null) continue block3;
                    } while (!((container = container.getParent()) instanceof PsiFile));
                    break;
                }
                return;
            }
        }
        if (container == null) {
            return;
        }
        TextRange range = DeclarationRangeUtil.getPossibleDeclarationAtRange(container);
        if (range == null) {
            return;
        }
        PsiElement _container = container;
        ApplicationManager.getApplication().invokeLater(() -> {
            LightweightHint hint1 = EditorFragmentComponent.showEditorFragmentHint(editor, range, true, true);
            if (hint1 != null) {
                hint1.putUserData(CONTAINER_KEY, _container);
                editor.putUserData(MY_LAST_HINT_KEY, new WeakReference<LightweightHint>(hint1));
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static boolean isDeclarationVisible(PsiElement container, Editor editor) {
        Rectangle viewRect = editor.getScrollingModel().getVisibleArea();
        TextRange range = DeclarationRangeUtil.getPossibleDeclarationAtRange(container);
        if (range == null) {
            return false;
        }
        LogicalPosition pos = editor.offsetToLogicalPosition(range.getStartOffset());
        Point loc = editor.logicalPositionToXY(pos);
        return loc.y >= viewRect.y;
    }
}

